#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "config.h"
#include "../mdm_lib/mdm_lib.h"
#include "msj.h"

char cfg_fich[FILENAME_MAX];
int cfg_lin= 0;

struct tel_fav *ult_fav;	/* auxiliar para la lista encadenada */


int leeconfig(void)
	{
	FILE *f;
	char *fich_cfg(void), *fc;
	static char linea[81];
	char *campo, *valor;
	void configura(char *campo, char *valor);
	int l;
	
	/* valores por defecto (muy defectuosos, por cierto) */
	config.vol= 190;
	config.mic= 190;
	strcpy( config.dev, "ttyS1" );
	config.tf= NULL;
	ult_fav= NULL;
	config.vel= MDM_VEL_38400;
	config.debug= 0;
	config.modo_x= 1;

	if( (fc=fich_cfg()) == NULL )
		return CFG_ERR_OK;	/* no hay fichero de configuracin */
		
	if( (f=fopen(fc,"rt"))==NULL ) {
		fprintf(stderr, MSJ_ERR_FICH_CFG, fc );
		return CFG_ERR_FOPEN;
		}

	strcpy(cfg_fich, fc);
	
	while( fgets(linea, CFG_MAX_LINEA+1, f)!=NULL ) {
		cfg_lin++;
		
		if( linea[0]!=CFG_CAR_COMENTARIO ) {
			campo= strtok(linea, " \t");
			if( campo==NULL )  
				valor= NULL;	/* lnea vaca */
			else {
				valor= strtok(NULL, "" );
				if( valor!=NULL ) {
					/* eliminar espacios al principio */
					while( *valor==' ' || *valor=='\t' )
						valor++;
				
					/* eliminar espacios al final (y el \n, si est) */
					l= strlen(valor)-1;
					while( *(valor+l)==' ' || *(valor+l)=='\t'
						|| *(valor+l)=='\n' )
						*(valor+l--)= 0;
						
					configura(campo,valor);
					}
				}
			}
		}
		
	fclose(f);
	
	return CFG_ERR_OK;
	}


char *fich_cfg(void)
	{
	char *env;
	static char nomfich[FILENAME_MAX];
	
		/* Orden de bsqueda: 
	
		a.- var. entorno
		b.- local (~/.<nombre>
		c.- global 
			c.1.- /etc/<nombre>
			c.2.- /usr/local/etc/<nombre>
	
		*/

	if( (env=getenv(CFG_VAR_ENTORNO)) != NULL ) 
		return env;						/* variable de entorno */
	else {
		sprintf( nomfich, "%s/.%s", getenv("HOME"), CFG_NOMBRE_FICH );
		
		if( !access(nomfich, R_OK) )
			return nomfich;				/* en directorio HOME */
		else {
			sprintf( nomfich, "/etc/%s", CFG_NOMBRE_FICH );
			
			if( !access(nomfich, R_OK) )
				return nomfich;			/* en /etc */
			else {
				sprintf( nomfich, "/usr/local/etc/%s", CFG_NOMBRE_FICH );
			
				if( !access(nomfich, R_OK) )
					return nomfich;		/* en /usr/local/etc */
				else
					return NULL;		/* no est en ningn lado */
				}
			}
		}
	}

	
void configura(char *campo, char *valor)
	{
	void anadefavorito(char *f);
	int v;
	
	if( !strcasecmp(campo, 			MSJ_VOL) )
		config.vol= atoi(valor);
	else if( !strcasecmp(campo, 	MSJ_MIC) )
		config.mic= atoi(valor);
	else if( !strcasecmp(campo, 	MSJ_DEV) )
		strncpy(config.dev, valor, 30);
	else if( !strcasecmp(campo, 	MSJ_FAV) )
		anadefavorito(valor);
	else if( !strcasecmp(campo,		MSJ_XPM) )
		strncpy(config.xpm, valor, 255);
	else if( !strcasecmp(campo, 	MSJ_TXT) ) 
		config.modo_x= 0;
	else if( !strcasecmp(campo, 	MSJ_VEL) ) {
		v= atoi(valor);
		switch(v) {
			case 19200:
				config.vel= MDM_VEL_19200;
				break;
				
			case 38400:
				config.vel= MDM_VEL_38400;
				break;
				
			case 57600:
				config.vel= MDM_VEL_57600;
				break;
				
			case 115200:
				config.vel= MDM_VEL_115200;
				break;
				
			case 230400:
				config.vel= MDM_VEL_230400;
				break;
			
			default:	/* velocidad incorrecta */
				fprintf( stderr, MSJ_ERR_VEL, cfg_fich, cfg_lin, campo );
			}
		}
	else
		/* ignoramos la opcin */
		fprintf( stderr, MSJ_ERR_IGN, cfg_fich, cfg_lin, campo );
	}


void anadefavorito(char *f)
	{
	char *nick, *nombre, *tel;
	struct tel_fav *fav;
	
	nick= strtok(f, "|");
	nombre= strtok(NULL, "|");
	tel= strtok(NULL, "|");
	
	if( nick==NULL || nombre==NULL || tel==NULL )
		/* lnea 'fav' incorrecta */
		fprintf( stderr, MSJ_ERR_FAV, cfg_fich, cfg_lin);

	fav= malloc(sizeof(struct tel_fav));
	fav->nick= strdup(nick);
	fav->nombre= strdup(nombre);
	fav->tel= strdup(tel);
	fav->sig= NULL;
	
	if( config.tf==NULL ) {	/* primer favorito */
		config.tf= fav;
		ult_fav= fav;
		}
	else {
		ult_fav->sig= fav;
		ult_fav= fav;
		}
	}
	