#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>
#include <unistd.h>
#include <ctype.h>

#include "aux.h"
#include "funciones.h"
#include "config.h"
#include "../mdm_lib/mdm_lib.h"
#include "msj.h"

#define TBUF 80
void muere(int retorno);
int colgado= 1;
int cogido= 1;


void coge_modem(void)
	{
	status(MSJ_COGIENDO);
	if( mdm_inicia(config.dev, config.vel) ) {
		fprintf( stderr, MSJ_ERR_MDMINI );
		cogido= 0; 	/* para evitar problemas en mdm_termina() de muere() */
		muere(1);
		}

	mdm_verboso= config.debug;
	cogido= 1;
	status("OK");
	}


void suelta_modem(void)
	{
	status(MSJ_SOLTANDO);
	if( cogido ) {
		mdm_termina();
		cogido= 0;
		}
	status("OK");
	}


void descuelga(void)
	{
	char buffer[TBUF];

	status(MSJ_DESCOLG);

	if( !cogido )
		coge_modem();
		
	/* clase 8: voz */
	if( mdm_escribe_espera( "AT#CLS=8", 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "CLS=8" );
		muere(1);
		}

	/* usar el speakerphone */
	if( mdm_escribe_espera( "AT#VLS=6", 5, buffer, "VCON" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "VLS=6" );
		muere(1);
		}

	/* ringback goes away */
	if( mdm_escribe_espera( "AT#VRA=25", 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "VRA" );
		muere(1);
		}
		
	/* dcimas de segundo de duracin de los DTMF generados */
	if( mdm_escribe_espera( "AT#VBT=1", 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "VBT" );
		muere(1);
		}

	/* descuelga (responge en voz) */
	if( mdm_escribe_espera( "ATA", 5, buffer, "VCON" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "ATA" );
		muere(1);
		}

	colgado= 0;
	status("OK");
	}


void cuelga()
	{
	char buffer[TBUF];
	
	status("Colgando");
	if( mdm_escribe_espera( "ATH", 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "ATH" );
		muere(1);
		}

	colgado= 1;
	status("OK");
	}


void dtmf(int digito)
	{
	char buffer[TBUF], buffdt[TBUF];

	if( !cogido || colgado )
		return;
		
	if( digito>=0 && digito<=9 )
		sprintf( buffdt, "AT#VTS=%d", digito );
	else if(digito==-1)
		sprintf( buffdt, "AT#VTS=*\n" );
	else 
		sprintf( buffdt, "AT#VTS=#\n" );
	
	if( mdm_escribe_espera( buffdt, 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "AT#VTS..." );
		muere(1);
		}
	}

		
void marca_dtmf( char *numero )
	{
	int l, i;
	
	l= strlen(numero);

	for( i=0 ; i<l ; i++) {
		if( isdigit( numero[i] ) )
			dtmf( numero[i]-'0' );
		else if( numero[i]=='*' )
			dtmf(-1);
		else if( numero[i]=='#' )
			dtmf(-2);
		else
			printf( MSJ_ERR_NUMERO, numero[i] );
		}
	}

	
void fija_vol(int vol)
	{
	char buffer[TBUF], bufferat[TBUF];

	sprintf( bufferat, "AT#VGR=%d", vol );
	if( mdm_escribe_espera( bufferat, 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "AT#VGR" );
		muere(1);
		}
	}
	

void fija_mic(int mic)
	{
	char buffer[TBUF], bufferat[TBUF];

	sprintf( bufferat, "AT#VGT=%d", mic );
	if( mdm_escribe_espera( bufferat, 5, buffer, "OK" ) ) {
		fprintf( stderr, MSJ_FIN_PLAZO, "AT#VGT" );
		muere(1);
		}
	}

		
void muere(int retorno)
	{
	status(MSJ_TERMIN);
	if( cogido )
		mdm_termina();
	status("OK");
	exit(retorno);
	}


