#include <forms.h>

#include "lfono-form.h"
#include "funciones.h"
#include "config.h"
#include "aux.h"
#include "msj.h"

char numero_visor[25];
void actualiza_visor(void);
FD_lfono *form_ppal;


void inicia_form(int *pargc, char *argv[])
	{
	int cierra_form(FL_FORM *f, void *d);
	void cb_dblclick_favorito(FL_OBJECT *ob, long data);
	void rellena_favoritos(void);
    Pixmap p, mascara;
	unsigned w, h;
	
	fl_initialize(pargc, argv, 0, 0, 0);
	form_ppal= create_form_lfono();

	/* desactivar los botones de control hasta que se active el linxfono */
	fl_deactivate_object(form_ppal->g_botones);
	fl_set_object_lcol(form_ppal->g_botones, FL_INACTIVE_COL );
	fl_deactivate_object(form_ppal->g_niveles);
	fl_set_object_lcol(form_ppal->g_niveles, FL_INACTIVE_COL );
	fl_deactivate_object(form_ppal->favoritos);
	fl_set_object_lcol(form_ppal->favoritos, FL_INACTIVE_COL );

	/* rtulos en su idioma */
	fl_set_object_label(form_ppal->descolgar, MSJ_ROTULO_DESCOLGAR );
	fl_set_object_label(form_ppal->salir, MSJ_ROTULO_SALIR );

	p= fl_read_pixmapfile(fl_root, config.xpm, &w, &h, &mascara, 0, 0, 0);
	fl_set_form_icon(form_ppal->lfono, p, mascara);
	
	/* fijar volumen y micrfono */
	fl_set_slider_value(form_ppal->vol, config.vol);
	fl_set_slider_value(form_ppal->mic, config.mic);

	fl_set_atclose(cierra_form, NULL);
	
	fl_set_browser_dblclick_callback( form_ppal->favoritos, 
		cb_dblclick_favorito, 0L );
	
	rellena_favoritos();
	}	



void cb_onoff(FL_OBJECT *ob, long data)
	{
	if( fl_get_button(ob) ) {
		/* pulsado: on */
		coge_modem();
		fl_activate_object(form_ppal->descolgar);
		fl_set_object_lcol(form_ppal->descolgar, FL_BLACK );
		}
	else {
		suelta_modem();
		fl_deactivate_object(form_ppal->descolgar);
		fl_set_object_lcol(form_ppal->descolgar, FL_INACTIVE_COL );
		}
	}


void cb_descolgar(FL_OBJECT *ob, long data)
	{
	numero_visor[0]= 0;
	actualiza_visor();
	
	if( colgado ) {
		descuelga();
		fl_activate_object(form_ppal->g_botones);
		fl_set_object_lcol(form_ppal->g_botones, FL_BLACK );
		fl_activate_object(form_ppal->g_niveles);
		fl_set_object_lcol(form_ppal->g_niveles, FL_BLACK );
		fl_activate_object(form_ppal->favoritos);
		fl_set_object_lcol(form_ppal->favoritos, FL_BLACK );
		fl_redraw_object(form_ppal->favoritos);
		
		fl_set_object_label(ob, MSJ_ROTULO_COLGAR );
		}
	else {
		fl_deactivate_object(form_ppal->g_botones);
		fl_set_object_lcol(form_ppal->g_botones, FL_INACTIVE_COL );
		fl_redraw_object(form_ppal->g_botones );
		fl_deactivate_object(form_ppal->g_niveles);
		fl_set_object_lcol(form_ppal->g_niveles, FL_INACTIVE_COL );
		fl_redraw_object(form_ppal->g_niveles );
		fl_deactivate_object(form_ppal->favoritos);
		fl_set_object_lcol(form_ppal->favoritos, FL_INACTIVE_COL );
		fl_redraw_object(form_ppal->favoritos );

		fl_set_object_label(ob, MSJ_ROTULO_DESCOLGAR );
		fl_redraw_object(ob);
		
		cuelga();
		}
	}


void cb_boton(FL_OBJECT *ob, long data)
	{
	switch(data)
		{
		case 0L:
			strcat( numero_visor, "0" );
			actualiza_visor();
			dtmf(0);
			break;
			
		case 1L:
			strcat( numero_visor, "1" );
			actualiza_visor();
			dtmf(1);
			break;
		
		case 2L:
			strcat( numero_visor, "2" );
			actualiza_visor();
			dtmf(2);
			break;

		case 3L:
			strcat( numero_visor, "3" );
			actualiza_visor();
			dtmf(3);
			break;

		case 4L:
			strcat( numero_visor, "4" );
			actualiza_visor();
			dtmf(4);
			break;

		case 5L:
			strcat( numero_visor, "5" );
			actualiza_visor();
			dtmf(5);
			break;

		case 6L:
			strcat( numero_visor, "6" );
			actualiza_visor();
			dtmf(6);
			break;

		case 7L:
			strcat( numero_visor, "7" );
			actualiza_visor();
			dtmf(7);
			break;

		case 8L:
			strcat( numero_visor, "8" );
			actualiza_visor();
			dtmf(8);
			break;

		case 9L:
			strcat( numero_visor, "9" );
			actualiza_visor();
			dtmf(9);
			break;

		case -1L:
			strcat( numero_visor, "*" );
			actualiza_visor();
			dtmf(-1);
			break;

		case -2L:
			strcat( numero_visor, "#" );
			actualiza_visor();
			dtmf(-2);
			break;

		default:
			fprintf( stderr, MSJ_ERR_ARG_CBBOTON, data );
		}
	}


void cb_marca_favorito(FL_OBJECT *ob, long data)
	{
	void cb_dblclick_favorito(FL_OBJECT *ob, long data);
	
	/* de momento vale tambin con slo un click */
	cb_dblclick_favorito(ob, data);
	}


void cb_dblclick_favorito(FL_OBJECT *ob, long data)
	{
	int n, i;
	struct tel_fav *f;
	
	n= fl_get_browser(ob);
	
	f= config.tf;
	
	for( i= 1; i<n ; i++ ) {
		if( f==NULL ) {
			fprintf( stderr, MSJ_ERR_FAV_RARO );
			return;
			}
		f= f->sig;
		}
	
	strcpy( numero_visor, f->tel );
	actualiza_visor();
	
	printf( "marcando... %s\n", f->nombre );
	marca_dtmf(f->tel);
	}


void cb_vol(FL_OBJECT *ob, long data)
	{
	int v;
	
	v= (int)fl_get_slider_value(ob);
	fija_vol(v);
	}


void cb_mic(FL_OBJECT *ob, long data)
	{
	int m;
	
	m= (int)fl_get_slider_value(ob);
	fija_mic(m);
	}


void cb_salir(FL_OBJECT *ob, long data)
	{
	suelta_modem();
	fl_finish();
	exit(0);
	}


int cierra_form(FL_FORM *f, void *d)
	{
	suelta_modem();
	return 0;
	}


void actualiza_visor(void)
	{
	fl_set_object_label(form_ppal->visor, numero_visor);
	fl_redraw_object(form_ppal->visor);
	}


void rellena_favoritos(void)
	{
	struct tel_fav *f;

	fl_clear_browser(form_ppal->favoritos);
	
	f= config.tf;
	while( f!=NULL ) {
		fl_add_browser_line( form_ppal->favoritos, f->nombre);
		f= f->sig;
		}
	}
