#include <stdio.h>
#include <getopt.h>

#include "forms.h"
#include "lfono-form.h"
#include "config.h"
#include "funciones.h"
#include "aux.h"
#include "msj.h"

extern FD_lfono *form_ppal; /* en interfaz-x.c */


int main(int argc, char *argv[])
	{
	extern void inicia_form(int *pargc, char *argv[]);
	void analiza_opciones(int argc, char *argv[]);
	void modo_texto(void);
	
	printf( MSJ_INICIO );

	leeconfig();
	analiza_opciones(argc, argv);

	if(config.modo_x)
		inicia_form(&argc, argv);
	
	coge_modem();
	fija_vol(config.vol);
	fija_mic(config.mic);	

	if(config.modo_x) {
		fl_show_form(form_ppal->lfono,FL_PLACE_CENTER,FL_FULLBORDER,"lfono");
		fl_do_forms();
		}
	else {	/* modo texto */
		modo_texto();
		}

	return 0;
	}


void analiza_opciones(int argc, char *argv[])
	{
	char opcion;
	
	while( (opcion= (char)getopt( argc, argv, "hvt" )) != EOF ) {
		switch(opcion) {
			case 'h':
			case '?':
				printf( MSJ_AYUDA_1 );
				printf( MSJ_AYUDA_2, argv[0] );
				printf( MSJ_AYUDA_3 );
				exit(opcion=='h'?0:1);
				
			case 'v':
				config.debug= 1;
				break;
				
			case 't':
				config.modo_x= 0;
				break;
				
			default:
				fprintf( stderr, MSJ_ERR_ARGS );
			}
		}
	}
