/*
 * $Id: getitem.c,v 1.6 1998/02/17 09:51:52 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/getitem/getitem.c,v $
 * $Revision: 1.6 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <stdio.h>

#include <liberror/liberror.h>
#include <libconf/libconf.h>

#ifdef HAS_GETOPT_H
#include <getopt.h>
#endif
extern char* optarg;

#define USAGE_MSG \
  "getitem (" ## VERSION ## ")\n"\
  "usage:\n" \
  "      getitem [-h] [-v] configfile group key\n" \
  "\n" \
  "where:\n"\
  "     -h           print out this message\n" \
  "     -v           displays version information\n" \
  "     configfile   Name of configuration file from which information\n" \
  "                  should be retrieved.\n"\
  "     group        Name of group in which has to be searched\n" \
  "     key          The key that is searched for in group.\n" \
  "\n" 

#define VERSION_MSG \
   "getitem version " ## VERSION ## "\n"
   
static void usage()
{
   fprintf( stderr, USAGE_MSG );
}

static void version()
{
   fprintf( stdout, VERSION_MSG );
}

int main( int argc, char* argv[] )
{
   conf_file *cf;
   char* config_file;
   char* group;
   char* key;
   char* value;

   /* Process -h command line option */
   if( argc == 2 && strcmp( argv[1], "-h" ) == 0 )
   {
      usage();
      exit( 0 );
   }
   
   /* Process -v command line option */
   if( argc == 2 && strcmp( argv[1], "-v" ) == 0 )
   {
      version();
      exit( 0 );
   }
   
   if( argc != 4 )
   {
      usage();
      exit( 1 );
   }
   
   config_file = argv[1];
   group = argv[2];
   key = argv[3];
   
   cf = open_conf( config_file );
   if( cf == NULL )
   {
      FAIL( "open_conf" );
      exit( 1 );
   }

   value = get_str( cf, group, key, "" );
   
   printf( "%s\n", value );
   
   close_conf( cf );
   exit( 0 );
}

/* EOF getitem/getitem.c */
