.\"
.\" $Id: getitem.man,v 1.8 1998/02/17 09:51:53 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/getitem/getitem.man,v $
.\" $Revision: 1.8 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH getitem 1 "Oct 26, 1997"
.SH NAME
getitem \- Tool to retrieve items from a configuration file.
.SH SYNOPSYS
.B getitem [-h] [-v]
\fIconfig-file\fP \fIgroup\fP \fIkey\fP

.SH DESCRIPTION 

The \fIgetitem\fP program is a tool that retrieves data from configuration
files. It is used in the modem package to retrieve elements from the personal
phone book (see phonebook(5)). Given a \fIgroup\fP name and a \fIkey\fP, the
tool prints the value corresponding to the entry '\fIkey\fP = value' in
\fIgroup\fP on standard output. When no key can be found, the empty string is
printed on standard output.

.SH OPTIONS
The following optional command line options are understood by \fIgetitem\fP:
.TP 8
.B -h
This causes \fIgetitem\fP to print out a verbose message describing its
options.
.TP 8
.B -v
Prints the version number of \fIgetitem\fP to standard output.

.SH OPERANDS
The following arguments are required by \fIgetitem\fP:
.TP 8
.I config-file
The name of the configuration file that has to be used.
In the modem package \fIgetitem\fP is used to access the personal
phonebook (~/.phonebook).
.TP
.I group
The name of the group in the configuration file in which key has to be
searched.

.TP
.I key
The item that has to be searched.

.SH EXAMPLES
You can use \fIgetitem\fP to obtain the speed of a configured modem (see
modems.conf(5)):

% getitem /etc/modems.conf modem speed

Or you can use the tool to retrieve the phone number corresponding to
the phone book entry \fIuniversity\fP:

% getitem ~/.phonebook university number

.SH EXIT STATUS
The following exit values are returned:
.TP 4
.B 0
Successful completion
.TP
.B >0
An error occurred. The configuration file could not be opened or no entry
exists for the given key.

.SH SEE ALSO
.BR ppp "(1), 
.BR phonebook "(5),
.BR modems.conf "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)

.\"
.\" EOF getitem/getitem.man
.\"
