/*
 * $Id: libconf.h,v 1.8 1998/02/17 09:51:55 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libconf/libconf.h,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _libconf_h
#define _libconf_h

#include <stdio.h>

#ifdef False
#undef False
#endif

#ifndef Bool
#ifdef True
#undef True
#endif
#ifdef Bool
#undef Bool
#endif

typedef enum
{
   False,
   True
} Bool;
#endif

typedef enum
{
   noErr = 1,
   sysErr,
   badConfFile,
   notFound
} confErr;

typedef struct cf_item
{
   char* key;
   char* value;
   char* comment;
   struct cf_item* next;
} item;

typedef struct cf_grp
{
   char* grpName;
   item* items;
   char* comment;
   struct cf_grp* next;
} grp;

   
   

typedef struct 
{
   confErr  err;
   Bool     case_significant;
   char*    fileName;
   grp*     groups;
   grp*     currGroup;
   item*    currItem;
   char*    comment;
} conf_file;




/* Open, Close, Write */
conf_file* open_conf( const char* file );
Bool       close_conf( conf_file* cf );
Bool       write_conf( conf_file* cf );




/* 
 * Goto:  group/item
 * Query: current group/item, group/conf empty
 */
grp*       current_group( conf_file* cf );
item*      current_item( conf_file* cf );

grp*       goto_group( conf_file* cf, char* gName );
item*      goto_item( conf_file* cf, char* iName );

grp*       goto_first_group( conf_file* cf );
grp*       goto_next_group( conf_file* cf );

item*      goto_first_item( conf_file* cf );
item*      goto_next_item( conf_file* cf );

Bool       group_empty( conf_file* cf );
Bool       conf_empty( conf_file* cf );




/*
 * Get: groupName, itemKey, itemValue
 *      int, string
 */
char*      group_name( grp* Group );
char*      item_key( item* i );
char*      item_value( item* i );

char*      get_str( conf_file* cf, char* group, char* Item, char* Default );
int        get_int( conf_file* cf, char* group, char* Item, int Default );




/*
 * Set: string, int
 */
Bool       set_str( conf_file* cf, char* group, char* Item, char* value );
Bool       set_int( conf_file* cf, char* group, char* Item, int value );




/*
 * Create/Delete Group/Item
 */
grp*       create_new_group( conf_file* cf, char* gName );
item*      create_new_item( conf_file* cf, char* iName );

Bool       del_group( conf_file* cf, char* gName );
Bool       del_item( conf_file* cf, char* gName, char* iName );




/*
 * misc
 */
void       case_significant( conf_file* cf );
void       case_insignificant( conf_file* cf );
confErr    get_error( conf_file* cf );


#endif
/*
 * EOF libconf/libconf.h
 */
