/*
 * $Id: liberror.h,v 1.10 1998/02/17 09:51:57 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/liberror/liberror.h,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _liberror_h
#define _liberror_h

#include <stdio.h>

/*
 * _errorFuncPtr: pointer to error function. Used to set or get
 * error function.
 */
typedef void (*_errorFuncPtr)( const char* );

/*
 * error: Use this function to indicate error condition. The behaviour of
 * this function can be changed by calling setErrorFunc.
 *
 * Note: this function works like the printf functions. The '%m' option
 * also works.
 */
void error( const char* fmt, ... );

/*
 * setErrorFunc: Specify a function that handles errors. The default
 * action is to print the error message on stderr. Using this function,
 * you can change that behaviour.
 */
void setErrorFunc( _errorFuncPtr );

/*
 * getErrorFunc: Get the current error handling function.
 */
const _errorFuncPtr getErrorFunc();

/*
 * Return a timestamp.
 * It returns the time and date in the current locale.
 */
const char* timeStamp();

#define FAIL(x) error( "%s(%d): %s: %m", __FILE__, __LINE__, x )
#define FAIL1(x,y) error( "%s(%d): %s(%s): %m", __FILE__, __LINE__, x, y )
#define FAILn(x,y) error( "%s(%d): " ## x, __FILE__, __LINE__, y )

#define DB fprintf(stderr, "%s-%d\n", __FILE__, __LINE__ );
#endif

/*
 * EOF liberror/liberror.h
 */
