.\"
.\" $Id: liberror.man,v 1.8 1998/02/17 09:51:58 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/liberror/liberror.man,v $
.\" $Revision: 1.8 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH liberror 3 "January 13, 1997"
.SH NAME
liberror \- Error handling routines.
.SH SYNOPSYS
.nf
.B #include <liberror/liberror.h>
.sp
.BI "typedef void (*"_errorFuncPtr ")( const char* "errmsg " );
.sp
.BI "void error( const char* "fmt ", ... );
.sp
.BI "void setErrorFunc( _errorFuncPtr "ptr " );
.sp
.BI "const _errorFuncPtr getErrorFunc();
.sp
.BI "const char* timeStamp();
.fi

.SH DESCRIPTION
The 
.B liberror
routines provide an uniform way of error handling.
Everywhere in the program you can specify how errors should be handled
without changing the code that generated the error.
Every routine that causes a fatal error, the function
.B error
should be called. That function generates an  error message and 
calls a specified
function that displays the message and further handles the error.


.B error
is the function that should be called whenever a fatal error occurs. The
function creates an error message as specified by
.IR fmt ,
in a similar way to 
printf(3).
.B error
also handles the
.B %m
option, which, on some systems is not supported by the printf functions.
This option represents the error string
.B sys_errlist[errno]. 

.B setErrorFunc
sets the error handler function called by 
.B error
to
.IR ptr .
Use this function when you want to change the behavior of the error
handling.
The default action is to print the error message to
.B stderr.

.B getErrorFunc
returns a pointer to the current error handler.

.B timeStamp
returns a pointer to an internal buffer containing a time stamp in the format
of the current locale. It calls
strftime(3)
with "\fB[%c]\fP" as format.

.SH SEE ALSO
.BR printf "(3), 
.BR strftime "(3)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
.\"
.\" EOF liberror/liberror.man
.\"
