/*
 * $Id: libmclient.h,v 1.7 1998/02/17 09:52:03 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libmclient/libmclient.h,v $
 * $Revision: 1.7 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _libmclient_h
#define _libmclient_h

#include <libprotocol/libprotocol.h>

#define MODEM_DATA       PROT_DATA
#define MODEM_CMD_REPLY  PROT_REPLY
#define MODEM_ERROR      PROT_ERROR
typedef protType modemDataType;

#define modemDataTypeOf    protTypeOf
#define modemDataSubTypeOf protSubTypeOf

typedef protHandler modemHandler;

int  modemClientConnect( const char* host );
void modemClientDisconnect();
void modemClientHangup();
void modemClientDial( const char* number );

int  modemClientWrite( void* data, size_t length );
int  modemClientRead();

void modemClientSetHandler( modemDataType, modemHandler );

#endif

/*
 * EOF libmclient/libmclient.h
 */
