/*
 * $Id: match.c,v 1.8 1998/02/17 09:52:06 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libmodem/match.c,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include "match.h"
 
typedef struct 
{
   char buf[40];
   int lookup;
   int item;
   int bytes;
} _matchData;

static _matchData matchData;

void matchInit( void )
{        
   matchData.lookup = 
   matchData.item =
   matchData.bytes = 0;

} 
 
   
int matchOneChar( const char* str[], char c, int option )
{
   if( c == '\r' || c == '\n' )
      return MATCH_INCONCLUSIVE;
   matchData.buf[matchData.bytes] = c;
   matchData.bytes++;
   matchData.buf[matchData.bytes] ='\0';

/*
fprintf( stderr, "%c", c );
fflush(stderr);   
*/
   do
   {
      if( toupper( str[matchData.item][matchData.lookup] ) == 
          toupper( matchData.buf[matchData.lookup] ) )
      {
         if( str[matchData.item][matchData.lookup+1] == '\0' )
            return matchData.item;
         matchData.lookup++;
      }
      else
      {
         matchData.lookup = 0;
         matchData.item++;
         if( str[matchData.item] == NULL )
            matchData.item = 0;
         if( matchData.item == 0 )
         {
            if( option == MATCH_BEGINNING )
               return MATCH_NO_MATCH;
            if( matchData.bytes > 0 )
               memmove( matchData.buf, matchData.buf + 1, matchData.bytes-- );
         }
      }
   } while( matchData.bytes > matchData.lookup );
   return MATCH_INCONCLUSIVE;
}

int matchText( const char* str[], int option, char (*rfunc)() )
{
   int status;
   char c;
   
   matchInit();
   
   do
   {
      c = rfunc();
      status = matchOneChar( str, c, option );
   } while( status == MATCH_INCONCLUSIVE );
   return status;
}

/*
 * EOF libmodem/match.c
 */
