/*
 * $Id: modem.c,v 1.11 1998/02/17 09:52:07 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libmodem/modem.c,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
/*
 * dip      A program for handling dialup IP connecions.
 *      Modem driving module.  On systems that support the
 *      dial(3) package, we (should) use that.  Otherwise,
 *      we use a very rudimentary HAYES-type dialer.
 *
 * 
 *
 *    Author:    Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *      Copyright 1988-1993 MicroWalt Corporation
 *
 *      This program is free software; you can redistribute it
 *      and/or  modify it under  the terms of  the GNU General
 *      Public  License as  published  by  the  Free  Software
 *      Foundation;  either  version 2 of the License, or  (at
 *      your option) any later version.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/types.h>

#include <liberror/liberror.h>
#include <libconf/libconf.h>
#include <libport/libport.h>

#include "libmodem.h"

/* Structure containing modem commands */
static modem_commands commands =
{
   ATTN,
   RSET,
   INIT,
   DIAL,
   HANGUP
};


/* Pointers to read/write functions */
static modemReadFuncPtr modemReadFunc = read;
static modemWriteFuncPtr modemWriteFunc = write;

/* End of Line character */
#define AT_EOL   "\r"

/* Until you set the modem commands with mdm_set_commands
 * you can't do anything
 */
static int   mdm_setup = 0;         /* can we do anything?   */

/* 
 * Read from the modem, using modemReadFunc.
 * modemReadFunc can be changed to point to your own read function
 */
int modemRead( int fd, void* data, size_t length )
{
   int status;
   TEMP_FAILURE_RETRY( status, modemReadFunc( fd, data, length ) );
   return status;
}

/* 
 * Write to modem, using modemWriteFunc.
 * modemWriteFunc can be changed to point to your own write function.
 */
int modemWrite( int fd, void* data, size_t length )
{
   int status;
   TEMP_FAILURE_RETRY( status, modemWriteFunc( fd, data, length ) );

   return status;
}

/* Let the modem functions use your own read function */
void setModemReadFunc( modemReadFuncPtr newReadFunc )
{
   modemReadFunc = newReadFunc;
}

/* Let the modem functions use your own write function */
void setModemWriteFunc( modemWriteFuncPtr newWriteFunc )
{
   modemWriteFunc = newWriteFunc;
}

/* 
 * Initialize the modem commands and indicate that the modem
 * is now setup
 */
int mdm_init( int fd, char* modem, const char* confFile )
{
   int  result;
   char buff[128];
   conf_file* cf;
   char mdm_type[20];
   
   strcpy( mdm_type, DEF_MODEM_TYPE );
   
   cf = open_conf( confFile );
   if( cf != NULL )
   {
      strcpy( mdm_type, get_str( cf, modem, "type", DEF_MODEM_TYPE ) );
      close_conf(cf );
   }
   cf = open_conf( MODEM_COMMANDS );
   if( cf != NULL )
   {
      strcpy( commands.AT_ATTN,  get_str( cf, mdm_type, ATTN_ITEM, ATTN ) );
      strcpy( commands.AT_RSET,  get_str( cf, mdm_type, RSET_ITEM, RSET ) );
      strcpy( commands.AT_INIT,  get_str( cf, mdm_type, INIT_ITEM, INIT ) );
      strcpy( commands.AT_DIAL,  get_str( cf, mdm_type, DIAL_ITEM, DIAL ) );
      strcpy( commands.AT_HANGUP, get_str( cf, mdm_type, HANGUP_ITEM, HANGUP ) );
      close_conf( cf );
   }
   /* Setup to dial out. */
   sprintf(buff, "%s%s%s", AT_EOL, commands.AT_INIT, AT_EOL);

   result = modemWrite( fd, buff, strlen(buff)  );
   if( result < 0 )
   {
      FAIL( "modemWrite" );
      exit( 1 );
   }
   mdm_setup = 1;
   return 0;
}


/* Dial a phone number. */
int mdm_dial(int fd,const  char *number)
{
   int  result;
   char buff[128];

   if( mdm_setup == 1 ) 
   {
      /* Dial the phone number. */
      sprintf(buff, "%s%s%s", AT_EOL, commands.AT_INIT, AT_EOL);
      result = modemWrite( fd, buff, strlen(buff)  );
      if( result < 0 )
      {
         FAIL( "modemWrite" );
         exit( 1 );
      }

      sleep( 1 );

      sprintf(buff, "%s%s%s", commands.AT_DIAL, number, AT_EOL);
      result = modemWrite( fd, buff, strlen( buff ) );
      if( result < 0 )
      {
         FAIL( "modemWrite" );
         exit( 1 );
      }
      
      return 0;
   }
   return -1;
}

/* Hangup phone */
int mdm_hangup( int fd )
{
   int  result;
   char buf[128];
      
   if( mdm_setup == 1 )
   {
      result = modemWrite( fd, commands.AT_ATTN, strlen( commands.AT_ATTN ) );
      if( result < 0 )
      {
         FAIL( "modemWrite" );
         exit( 1 );
      }
      
      sleep( 1 );
      sprintf( buf, "%s%s", commands.AT_HANGUP, AT_EOL );
      result = modemWrite( fd, buf, strlen( buf ) );
      if( result < 0 )
      {
         FAIL( "modemWrite" );
         exit( 1 );
      }
      
      mdm_flush( fd, 1 );
      return 0;
   }
   return -1;
}

/* Reset modem */
int mdm_reset(int fd )
{
   int  result;
   char buff[128];

   if ( mdm_setup == 1 )
   {
      /* Make the modem listen to us. */
      result = modemWrite( fd, commands.AT_ATTN, strlen( commands.AT_ATTN ) );
      if( result < 0 )
      {
         FAIL( "modemWrite" );
         exit( 1 );
      }
      
      sleep( 1 );

      /* Reset the modem. */
      sprintf( buff, "%s%s", commands.AT_RSET, AT_EOL );
      result = modemWrite( fd, buff, strlen( buff ) );
      if( result < 0 )
      {
         FAIL( "modemWrite" );
         exit( 1 );
      }
      
      return 0;
  }
  return -1;
}

int mdm_flush( int fd, int sec )
{
   struct timeval timeout;
   int retval;
   int bytes = 0;
   fd_set fds;
   char buf[128];
   
   timeout.tv_sec = sec;
   timeout.tv_usec = 0;

   while( 1 )
   {
      FD_ZERO( &fds );
      FD_SET( fd, &fds );
      
      TEMP_FAILURE_RETRY( retval,
                          select( FD_SETSIZE, &fds, NULL, NULL, &timeout ) );
      
      timeout.tv_sec = 0;
      timeout.tv_usec = 0;

      if( retval < 0 )
      {
         FAIL( "select" );
         exit( 1 );
      }
      
      if( retval == 0 )
         return bytes;
      
      TEMP_FAILURE_RETRY( retval,
                          read( fd, buf, sizeof buf ) );
      if( retval < 0 )
      {
         FAIL( "read" );
         exit( 1 );
      }
      
      bytes += retval;
   }
}
    
/*
 * EOF libmodem/modem.c
 */
