/*
 * $Id: modem.h,v 1.8 1998/02/17 09:52:08 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libmodem/modem.h,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _modem_h
#define _modem_h

#include <stddef.h>

/* 
 * Modem commands. You should initialize the modem functions
 * with the proper commands
 */ 
typedef struct 
{
   char AT_ATTN[40];
   char AT_RSET[40];
   char AT_INIT[40];
   char AT_DIAL[40];
   char AT_HANGUP[40];
} modem_commands;

/* These are the item names of the modem commands in the conf file */
#define ATTN_ITEM     "attn"
#define RSET_ITEM   "rset"
#define INIT_ITEM   "init"
#define DIAL_ITEM   "dial"
#define HANGUP_ITEM "hangup"

/* 
 * You can change the default read/write functions used by
 * the modem routines. The default functions are read, write
 */
typedef int (*modemReadFuncPtr)(int, void*, size_t );
typedef int (*modemWriteFuncPtr) (int, const void*, size_t );
void setModemReadFunc( modemReadFuncPtr );
void setModemWriteFunc( modemWriteFuncPtr );

/*
 * Use these functions to read/write data from/to the modem
 */
int modemRead( int, void*, size_t );
int modemWrite( int, void*, size_t );


/* Dial phone number */
int mdm_dial(int fd, const char *number);

/* Hangup the phone */
int mdm_hangup( int fd );


/* reset modem */
int mdm_reset(int fd );

/* 
 * This function should be called before any other modem functions.
 * It is used to set the proper modem commands for your modem
 */
int mdm_init( int fd, char* mdm, const char* cf );

int mdm_flush( int fd, int seconds );
#endif

/*
 * EOF libmodem/modem.h
 */
