/*
 * $Id: libphonebook.c,v 1.8 1998/02/17 09:52:10 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libphonebook/libphonebook.c,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "libphonebook.h"
#include "tilde_expand.h"

/*
 * Open phonebook.
 */   
phonebook* phonebookOpen( char* name )
{
   char path[__MAX_HOME_LEN__];

/* Parse shell characters in name */
   if( pathEval( path, name ) < 0 )
      return NULL;
/* Open the phonebook */
   return (phonebook*)open_conf( path );
}

/* Close the phonebook book */
void phonebookClose(  phonebook* book )
{
   if( book == NULL )
      return;
   close_conf( book );
}

/*
 * Find and return entry matching name
 *
 * result will only contain pointers to the data in the phonebook.
 * This means that after closing the phonebook, the pointers are
 * useless.
 */
int phonebookGetEntryByName( phonebook* book, 
                             phonebook_entry* result, 
                             char* name )
{
   grp* group;
   group = goto_group( book, name );
   if( group == NULL )
      return 0;
   result->name     = name;
   result->number   = get_str( book, name, NUMBER, NULL );
   result->login    = get_str( book, name, LOGIN, NULL );
   result->password = get_str( book, name, PASSWORD, NULL );
   result->type     = get_str( book, name, TYPE, NULL );
   return 1;
}

/*
 * Return first entry in phonebook 
 */
int phonebookGetFirstEntry( phonebook* book, phonebook_entry* result )
{
   grp* group;
   group = goto_first_group( book );
   if( group == NULL )
      return 0;
   return phonebookGetEntryByName( book, result, group_name( group ) );
}

/*
 * Return next entry in phonebook
 */
int phonebookGetNextEntry( phonebook* book, phonebook_entry* result )
{
   grp* group;
   group = goto_next_group( book );
   if( group == NULL )
      return 0;
   return phonebookGetEntryByName( book, result, group_name( group ) );
}

/*
 * EOF libphonebook/libphonebook.c
 */
