/*
 * $Id: libphonebook.h,v 1.7 1998/02/17 09:52:10 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libphonebook/libphonebook.h,v $
 * $Revision: 1.7 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _libphonebook_h
#define _libphonebook_h

#include <libconf/libconf.h>

/* These are the field names in the phonebook  currently used */
#define NUMBER      "number"
#define LOGIN      "login"
#define PASSWORD   "password"
#define TYPE      "type"

/* Typedef og phonebook and phonebook_entry */
typedef conf_file phonebook;
typedef struct
{
   char* name;
   char* number;
   char* login;
   char* password;
   char* type;
} phonebook_entry;

/* Open/Close phonebook */
phonebook* phonebookOpen( char* phonebook );
void phonebookClose(  phonebook* );

/* 
 * return phonebook_entry with name "name" 
 * you should give a pointer to a phonebook_entry
 */
int phonebookGetEntryByName( phonebook*, phonebook_entry*, char* name );
/*
 * Get first entry in phonebook.
 * you should give a pointer to a phonebook_entry.
 */
int phonebookGetFirstEntry( phonebook*, phonebook_entry* );
/*
 * Get next entry in phonebook
 * you should give a pointer to a phonebook_entry.
 */
int phonebookGetNextEntry( phonebook*, phonebook_entry* );


#endif
/*
 * EOF libphonebook/libphonebook.h
 */
