.\"
.\" $Id: libphonebook.man,v 1.8 1998/02/17 09:52:11 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/libphonebook/libphonebook.man,v $
.\" $Revision: 1.8 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH libphonebook 3 "January 13, 1997"
.SH NAME
libphonebook \- Library for phonebooks.
.SH SYNOPSYS
.nf
.B #include <libphonebook/libphonebook.h>
.sp
.BI "phonebook* phonebookOpen( char* " name " );
.sp
.BI "void phonebookClose( phonebook* "book " );
.sp
.BI "int phonebookGetEntryByName( phonebook* "book ","
.BI "                             phonebook_entry* " result ", char* "name " );
.sp
.BI "int phonebookGetFirstEntry( phonebook* "book ", phonebook_entry* "result " );
.sp
.BI "int phonebookGetNextEntry( phonebook* "book ", phonebook_entry* "result " );
.fi

.SH DESCRIPTION
This library contains routines for manipulating phonebooks.
For a description of the format of entrys in the phonebook see
phonebook(5).

The 
.IR phonebook 
datatype is an internal representation of a phonebook, you
need not worry about. The 
.IR phonebook_entry 
is defined as follows:

.br
.nf
.in 10

typedef struct  
{
.in 14
char* name;     /* Name of entry used for reference */
char* number;   /* Number to dial */
char* login;    /* Login name */
char* password; /* Password */
char* type;     /* Type of entry (e.g. fax, voice) */
.in 10
} phonebook_entry;
.fi
.PP

.B phonebookOpen
opens the phonebook
.IR name .
It returns a new phonebook on success or NULL on error, in which case 
.IR errno 
is set to indicate the error.

.B phonebookClose
closes the phonebook
.IR book .

.B phonebookGetEntryByName
finds an entry in the phonebook 
.IR book
which matches
.IR name .
The result is stored in
.IR result ,
which is a pointer to a valid phonebook_entry allocated by you.

On success the value 0 is returned. On error the value -1 is returned, 
which means no matching entry could be found.

.B phonebookGetFirstEntry
finds the first entry in the phonebook
.IR book .
The result is stored in
.IR result ,
which is a pointer to a valid phonebook_entry allocated by you.

On success the value 0 is returned. On error the value -1 is returned, which
means the phonebook is empty.

.B phonebookGetNextEntry
finds the next entry in the phonebook
.IR book .
The result is stored in
.IR result ,
which is a pointer to a valid phonebook_entry allocated by you.

On success the value 0 is returned. On error the value -1 is returned, which
means there is no next entry.

.SH BUGS
Currently you can't save entrys to the phonebook.

.SH SEE ALSO
.BR phonebook "(5)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)
.\"
.\" EOF libphonebook/libphonebook.man
.\"
