.\"
.\" $Id: phonebook.man,v 1.11 1998/02/17 09:52:12 mdejonge Exp $
.\"
.\"   $Source: /home/mdejonge/CVS/projects/modem/libphonebook/phonebook.man,v $
.\" $Revision: 1.11 $
.\"    Author: Merijn de Jonge
.\"     Email: mdejonge@wins.uva.nl
.\" 
.\"  
.\" 
.\" This file is part of the modem communication package.
.\" Copyright (C) 1996-1998  Merijn de Jonge
.\" 
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\" 
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\" 
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\" 
.\"
.TH phonebook 5 "January 13, 1997"
.SH NAME
phonebook \- users personal phone book

.SH DESCRIPTION 

The user's personal phone book (\fI~/.phonebook\fP) is used in combination
with the modem communication package. The tools xcomm(1) and
ppp(1) use the information in the phone book to determine the
number to dial. The latter tool also takes the login and password
from the phone book when possible.

The phone book consists of sections each containing a phone number
and possibly several other fields. The format of the phone book is as
follows:

[name_1]
   key1     = value1
   key2     = value2

[name_2]
   .
   .
   .


All key/value pairs are optional. When missing you are prompted to
enter values when needed. Options which are currently recognized by
the tools are:
.TP 10
.B number
The number to dial;
.TP 10
.B   login
Your user name used for authentication;
.TP 10
.B   password
Your password (use with care, see notes section below);
.TP 10
.B   type
Type of connection (see notes section below).
.TP 10
.B prelogin 
This item is used by \fIppp\fP(1) to send data to the remote site
before logging in. When the keyword \fIprompt\fP is used as value,
\fIppp\fP(1) will open a terminal window that lets you communicate with the
remote site directly. When the keyword \fIprompt\fP is not used, the text
specified as value to \fIprelogin\fP is sent to the remote site without user
intervention.
.TP 10
.B postlogin
This item is used by \fIppp\fP(1) to send data to the remote site after
logging in. Similar to \fIprelogin\fP the keyword \fIprompt\fP is used to
indicate that a terminal window has to be opened to communicate with the
remote site directly.

.LP
Other key/values are ignored. Comments start with \fI#\fP and are ended by
a newline. To update your phone book, use your favorite editor to
edit the file.

.SH EXAMPLE

The phonebook entry below defines a ppp connection named "xs4all".
The phone number is 622175. Before logging in several newlines
("\\n\\n\\n") are sent to obtain a login prompt. After logging in the
ppp service is started on the remote site by the command "ppp". Note
that \fIppp\fP(1) will prompt for a user name and password since they
are not specified in the phonebook entry.

   [xs4all]
      number   = 6222175
      type     = ppp
      prelogin = \\n\\n\\n
     postlogin = ppp

The second phonebook entry defines a ppp connection and uses an
interactive terminal window to communicate with the remote site after
logging in.

   [university]
       number   = 1234567
       type     = ppp
      postlogin = prompt

.SH NOTES 

The field \fItype\fP is currently unused but it will be used in the
future to select the right phone book entry when the same name is
used for several phone book entries. It is therefore recommended to
include the \fItype\fP field in your phone book. Examples are
\fIppp\fP, fIfax\fP and \fIxcomm\fP. The tool being used will select
the correct entry according to its type. Please take care when
defining the \fIpassword\fP field. Make sure your \fI.phonebook\fP is
unreadable for others, but note that even then your superuser is
still able to access your \fI.phonebook\fP.

.SH SEE ALSO
.BR modemcontrol "(1), 
.BR modemlogin "(1), 
.BR ppp "(1),
.BR xcomm "(1)

.SH AUTHOR
Merijn de Jonge (mdejonge@wins.uva.nl)

.\"
.\" EOF libphonebook/phonebook.man
.\"
