/*
 * $Id: tilde_expand.c,v 1.8 1998/02/17 09:52:12 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libphonebook/tilde_expand.c,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
/*
 * NCSA Mosaic for the X Window System                                      *
 * Software Development Group                                               *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 * mosaic@ncsa.uiuc.edu                                                     *
 *                                                                          *
 * Copyright (C) 1993, Board of Trustees of the University of Illinois      *
 *                                                                          *
 * NCSA Mosaic software, both binary and source (hereafter, Software) is    *
 * copyrighted by The Board of Trustees of the University of Illinois       *
 * (UI), and ownership remains with the UI.                                 *
 *                                                                          *
 * The UI grants you (hereafter, Licensee) a license to use the Software    *
 * for academic, research and internal business purposes only, without a    *
 * fee.  Licensee may distribute the binary and source code (if released)   *
 * to third parties provided that the copyright notice and this statement   *
 * appears on all copies and that no charge is associated with such         *
 * copies.                                                                  *
 *                                                                          *
 * Licensee may make derivative works.  However, if Licensee distributes    *
 * any derivative work based on or derived from the Software, then          *
 * Licensee will (1) notify NCSA regarding its distribution of the          *
 * derivative work, and (2) clearly notify users that such derivative       *
 * work is a modified version and not the original NCSA Mosaic              *
 * distributed by the UI.                                                   *
 *                                                                          *
 * Any Licensee wishing to make commercial use of the Software should       *
 * contact the UI, c/o NCSA, to negotiate an appropriate license for such   *
 * commercial use.  Commercial use includes (1) integration of all or       *
 * part of the source code into a product for sale or license by or on      *
 * behalf of Licensee to third parties, or (2) distribution of the binary   *
 * code or source code to third parties that need it to utilize a           *
 * commercial product sold or licensed by or on behalf of Licensee.         *
 *                                                                          *
 * UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR   *
 * ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED          *
 * WARRANTY.  THE UI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY THE    *
 * USERS OF THIS SOFTWARE.                                                  *
 *                                                                          *
 * By using or copying this Software, Licensee agrees to abide by the       *
 * copyright law and all other applicable laws of the U.S. including, but   *
 * not limited to, export control laws, and the terms of this license.      *
 * UI shall have the right to terminate this license immediately by         *
 * written notice upon Licensee's breach of, or non-compliance with, any    *
 * of its terms.  Licensee may be held legally responsible for any          *
 * copyright infringement that is caused or encouraged by Licensee's        *
 * failure to abide by the terms of this license.                           *
 *                                                                          *
 * Comments and questions are welcome and can be sent to                    *
 * mosaic-x@ncsa.uiuc.edu.                                                  *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

 
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include "tilde_expand.h"


/*---------------------------Utility Functions-----------------------------*/

/*
 * DA FORMAT:
 *   "src" is the pathname to check for ~ expansion. If a tilda is the
 *   first character, I expand it, store it in "dest", and return a 1.
 *   If the frist character is not a tilda, I return a 0. If "dest" does
 *   not exist, I return a -1.
 *
 * DA RULES:
 *   1) If the tilda is alone, expand it.
 *   Ex: '~'
 *   2) If the tilda is first, followed by an alphanumeric,
 *      stick the "path" to the home directory in front of
 *      it.
 *   Ex: '~spowers'
 *   3) Otherwise, leave it alone.
 *
 * DA FORMULA:
 *   1) If there is a HOME variable, use it.
 *   2) If there is a password entry, use the dir from it.
 *   3) Else...use /tmp.
 *
 */
int pathEval(char *dest, char *src) {

int i;
char *sptr, *hptr, home[__MAX_HOME_LEN__];
struct passwd *pwdent;

   /*
    * There is no place to store the result...punt.
    */
   if (!dest) {
#ifdef DEBUG
      printf("No place to put the Evaluated Path!\n");
#endif
      return(-1);
   }

   /*
    * There's nothing to expand
    */
   if (!src || !*src) {
      *dest='\0';
      return(0);
   }
   if (*src!='~') {
      strcpy(dest,src);
      return(0);
   }

   /*
    * Once here, we are gonna need to know what the expansion is...
    *
    * Try the HOME environment variable, then the password file, and
    *   finally give up and use /tmp.
    */
   if (!(hptr=getenv("HOME"))) {
      if (!(pwdent=getpwuid(getuid()))) {
         strcpy(home,"/tmp");
      }
      else {
         strcpy(home,pwdent->pw_dir);
      }
   }
   else {
      strcpy(home,hptr);
   }

   sptr=src;
   sptr++;
   /*
    * Nothing after the tilda, just give dest a value and return...
    */
   if (!sptr || !*sptr) {
      strcpy(dest,home);
      return(1);
   }

   /*
    * The next character is a slash...so prepend home to the rest of
    *   src and return.
    */
   if (*sptr=='/') {
      strcpy(dest,home);
      strcat(dest,sptr);
      return(1);
   }

   /*
    * Make the assumption that they want whatever comes after to be
    *   appended to the "HOME" path, sans the last directory (e.g.
    *   HOME=/opt/home/spowers, we would use /opt/home<REST OF "src">)
    */
   /*
    * Search backwards through home for a "/" on the conditions that
    *   this is not the slash that could possibly be at the _very_ end
    *   of home, home[i] is not a slash, and i is >= 0.
    *
    * If a slash is not found (i<0), then we assume that HOME is a
    *   directory off of the root directory, or something strange like
    *   that...so we simply ignore "home" and return the src without
    *   the ~.
    *
    * If we do find a slash, we set the position of the slash + 1 to
    *   NULL and store that in dest, then cat the rest of src onto
    *   dest and return.
    */
   for (i=strlen(home); (i>=0 && home[i]!='/') || i==strlen(home); i--);
   if (i<0) {
      strcpy(dest,sptr);
   }
   else {
      home[i+1]='\0';
      strcpy(dest,home);
      strcat(dest,sptr);
   }
   return(1);
}
/*
 * EOF libphonebook/tilde_expand.c
 */
