/*
 * $Id: basename.c,v 1.5 1998/02/17 09:52:14 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libport/basename.c,v $
 * $Revision: 1.5 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 *
 *
 *
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* some compilers start complaining when source file is empty */
static int keep_compiler_from_complaining;

#ifndef HAS_BASENAME
#include <string.h>

/*
 * deletes any prfix ending in / form path
 */
char* basename( char* path )
{
   char* sp;
   if ( path != NULL )
   {
      sp = strrchr( path, '/' );
      if( sp != NULL )
         return sp + 1;
   }
   return path;
}
#endif
/* EOF libport/basename.c */
