/*
 * $Id: libport.h,v 1.11 1998/02/17 09:52:15 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libport/libport.h,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _libport_h
#define _libport_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stddef.h>
#include <errno.h>

#ifndef HAS_BASENAME
char* basename( char* path );
#endif

#ifndef HAS_VSNPRINTF
#include <stdarg.h>
int vsnprintf( char* ptr, size_t length, const char* fmt, va_list args );
#endif /* HAS_VSNPRINTF */

#ifndef HAS_SETENV
int setenv( const char* name, const char* value, int overwrite );
#endif /* HAS_SETENV */

#ifndef HAS_ATEXIT
/* or compatibility for SunOS? */
#define atexit(f) on_exit(f, NULL);
#endif /* HAS_ATEXIT */

#include <sys/termios.h>
/*
 *
 *    This is from minicom,
 *
 *    Copyright 1991-1995 Miquel van Smoorenburg
 *
 *    This file is part of the minicom communications package,
 *    Copyright 1991-1995 Miquel van Smoorenburg.
 * 
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation; either version
 *    2 of the License, or (at your option) any later version.
 */
#ifndef TIOCMGET                    /* Posix */
   #ifdef TIOCMODG
      #define TIOCMGET TIOCMODG     /* BSD 4.3 */
   #else
      #ifdef MCGETA
         #define TIOCMGET MCGETA    /* HP/UX */
      #endif
   #endif
#endif
/* End minicom */


#if defined(TEMP_FAILURE_RETRY)
#undef TEMP_FAILURE_RETRY
#endif

#define TEMP_FAILURE_RETRY(__result, __expression) \
{\
   do {\
      __result = (long int)(__expression); \
   } while( __result == -1L && errno == EINTR);\
}   

#endif
/*
 * EOF libport/libport.h
 */
