/*
 * $Id: setenv.c,v 1.10 1998/02/17 09:52:16 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libport/setenv.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* some compilers start complaining when source file is empty */
static int keep_compiler_from_complaining;

#ifndef HAS_SETENV

#include <stdlib.h>
#include <stdio.h>
/*
 * Function:   setenv
 *
 * Description:
 * Emulation of function setenv,
 * using putenv and getenv.
 *
 * Arguments:
 *   - char*   name      Environment variable to set
 *   - char*   value     Value of variable to set
 *   - int               overwrite If zero don't overwrite value
 *
 * Returns:
 *   - int   0   On success
 *   - int   -1  On error 
 *
 * Remarks:
 *   This functions tests if name is already set in environment.
 *   If set and overwrite is zero, setenv does nothing, otherwise,
 *   if overwrite is non-zero, name will be set to value.
 *   
 */
int setenv( const char* name, const char* value, int overwrite )
{
   char* env_str;
   char* buf;
   int   status;
      
   env_str = getenv( name );
   if( env_str != NULL && overwrite == 0 )
      return 0;
   
   buf = (char*)malloc( strlen( name ) + strlen( value ) + 1 + 1);
   if( buf == NULL )
      return -1;
   
   sprintf( buf, "%s=%s", name, value );
   
   status = putenv( buf );
   
   return status;
}
   
#endif
/*
 * EOF libport/setenv.c
 */
