/*
 * $Id: libprotocol.h,v 1.9 1998/02/17 09:52:18 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libprotocol/libprotocol.h,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _libprotocol_h
#define _libprotocol_h

#include <stddef.h>
#include <errno.h>

#define PROT_CONNECT_REQUEST  0x00000001
#define PROT_REQUEST_OK       0x00000002
#define PROT_REQUEST_FAILED   0x00000004


#define PROT_DATA             0x00000001
#define PROT_COMMAND          0x00000002
#define PROT_REPLY            0x00000004
#define PROT_ERROR            0x00000008

#define MDM_DIAL              0x00000200
#define MDM_HANGUP            0x00000400
#define MDM_NO_CARIER         0x00000800
#define MDM_NO_DIALTONE       0x00001000
#define MDM_BUSY              0x00002000
#define MDM_ERROR             0x00004000
#define MDM_NO_ANSWER         0x00008000
#define MDM_CONNECT           0x00010000
#define MDM_EXIT              0x00020000

typedef unsigned int protType;
#define protTypeOf(x) (x & 0x00FF)
#define protSubTypeOf(x) (x & 0xFFFFFF00)

typedef void (*protHandler)( protType type, void* data, size_t length );

int  protConnectRequest( int );
int  protRequestConfirm( int, int );
void protSetHandler( protType type, protHandler handler );

int protSend( protType type, int fd, const void* data, size_t length );
int protReceive( int fd );


#define protBufSize   1024
#endif
/*
 * EOF libprotocol/libprotocol.h
 */
