/*
 * $Id: libtcpip.h,v 1.8 1998/02/17 09:52:20 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libtcpip/libtcpip.h,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _libtcpip_h
#define _libtcpip_h

#include <stddef.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
          
/* Type of protocol to use */
typedef enum
{
   UDP,
   TCP
} sockProtocol;

typedef struct
{
   int port;
   int fd;
   sockProtocol prot;
   struct sockaddr_in name;
} sockStruct;

/* Public functions */
int sockSetProtocol( sockStruct*, sockProtocol );
int sockSetPort( sockStruct*, int );

/* Set port to service described in /etc/services */
int sockSetPortToService( sockStruct*, char* service );

/* Become server */
int sockServer( sockStruct* );
/* Become client */
int sockClient( sockStruct*, const char* host );

int sockSetOption( sockStruct*, int option, int on );

/* Listen/Accept */
int sockListen( sockStruct* );
int sockAccept( sockStruct*, sockStruct* );

/* Connect to server */
int sockConnect( sockStruct* );

/* Who are we cvonnected to */
const char* sockConnectedTo( sockStruct* );

/* Send/Receive data */
int sockSend( sockStruct*, void* data, size_t size  );
int sockRecv( sockStruct*, sockStruct*, void* data, size_t size );
#endif

/*
 * EOF libtcpip/libtcpip.h
 */
