/*
 * $Id: pty.c,v 1.14 1998/02/17 09:52:22 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libtty/pty.c,v $
 * $Revision: 1.14 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "libtty.h"

#ifndef HAS_GRANTPT

/*
 * Allocate new pseudo terminal and store name of corresponding
 * slave device in slave
 *
 */
int openPtyMaster( char* slave_dev )
{
   char* s = NULL;
   char* t = NULL;
   char  buf[16];
   int   master;
   int   slave;
   /*
    * Try to open the master device 
    */
   strcpy( buf, "/dev/ptyXY" );
   
   for( s = "pqrstuvwxyzPQRST"; *s != '\0'; s++ )
   {
      buf[8] = *s;
      for( t = "0123456789abcdef"; *t != '\0'; t++ )
      {
         buf[5] = 'p';
         buf[9] = *t;
         master = open( buf, O_RDWR );
         if( master == -1 )
         {
            if( errno == ENOENT )
               return -1; /* out of pty devices */
            continue; /* try next pty device */
         }
         buf[5] = 't';
         strcpy( slave_dev, buf );
         slave = open( slave_dev, O_RDWR );

         /*
          * Try to open slave device. On failure, we continue
          * trying anopther pseudo terminal. On success we
          * close the slave and return its name in slave_dev
          */
         if( slave == -1 )
         {
            close( master );
         }
         else
         {
            close( slave );
            return master;
         }
      }
   }
   return -1; /* out of pty devices */
}

/*
 * open slave device.
 * Corresponding master device
 * should already have been opened
 *
 */  
int openPtySlave( char* slave )
{
   int fd;
   
   fd = open( slave, O_RDWR );

   return fd;
}

#else /* HAS_GRANTPT */
#include <stropts.h>
/*
 * Allocate new pseudo terminal and store name of corresponding
 * slave device in slave
 *
 */
int openPtyMaster( char* slave )
{
   char masterdev[16];
   char* ptr;
   int master;

   strcpy( masterdev, "/dev/ptmx" );
   
   /* open master device */
   master = open( masterdev, O_RDWR ) ;
   if( master < 0 )
      return -1;
   
   /* grant access to slave */
   if( grantpt( master ) < 0 )
   {
      close( master );
      return -1;
   }

   /* clear slave's lock flag */
   if( unlockpt( master ) < 0 )
   {
      close( master );
      return -1;
   }
   
   /* get slave's name */
   ptr = ptsname( master );
   if( ptr == NULL )
   {
      close( master );
      return -1;
   }
   strcpy( slave, ptr );
   return master;
}

int openPtySlave( char* slave )
{
   int fd;
   int status;
   
   fd = open( slave, O_RDWR );
   if( fd == -1 )
      return -1;
   
   
   status = ioctl( fd, I_PUSH, "ptem" );
   if( status < 0 )
   {
      close( fd );
      return -1;
   }
   
   status = ioctl( fd, I_PUSH, "ldterm" );
   if( status < 0 )
   {
      close( fd );
      return -1;
   }

   return fd;
}

   
#endif /* HAS_GRANTPT */


/*
 * EOF libtty/pty.c
 */
