/*
 * $Id: ttyfuncs.h,v 1.8 1998/02/17 09:52:24 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libtty/ttyfuncs.h,v $
 * $Revision: 1.8 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifndef _ttyfuncs_h
#define _ttyfuncs_h

#include <termios.h>
#include "libtty.h"

/* 
 * Several function used for tty's
 * These functions are used inside the library,
 * Not to be used outside.
 */

int   tty_set_raw(struct termios *tty);
int   tty_askfd(void);  
int   tty_databits(char *bits); 
int   tty_stopbits(char *bits); 
int   tty_parity(char *type);   
int   tty_speed(char *speed);   
int   tty_hangup(void);
int   tty_flush(int);
int   tty_close(void);
int   tty_reset(void);
int   tty_open(char *name);
char* lock_file_name( char* );
char* make_path( char* );
int   tty_already_locked( char* );
char* tty_device_name();

#endif
/*
 * EOF libtty/ttyfuncs.h
 */
