/*
 * $Id: dialI.c,v 1.10 1998/02/17 09:52:38 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/dialI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/MwmUtil.h>
#include <Xm/MessageB.h>

#include "libuiP.h"

#include <stdio.h>

 
static dialDialogInfoRec dialogInfo;

static Widget dialDialog;
static Widget phone_field;

static void dialDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 );
static void dialDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void dialDialogOk( Widget w, XtPointer p1, XtPointer p2 );

void dialDialogCreate()
{
   Widget dialog_contents,
          form;
   XmString label, ok_b, title;
   Arg args[10];
   int n;
   
   label = XmStringCreateLocalized( "   Please enter phone number to dial:   ");
   title = XmStringCreateSimple( "Phone Number" );
   ok_b = XmStringCreateLocalized( " Dial " );
   
   n = 0;
   XtSetArg( args[n], XmNautoUnmanage, False ); n++;
   XtSetArg( args[n], XmNmessageString, label ); n++;
   XtSetArg( args[n], XmNokLabelString, ok_b ); n++;
   XtSetArg( args[n], XmNwidth,    335 ); n++;
   XtSetArg( args[n], XmNheight, 200 ); n++;
   XtSetArg( args[n], XmNdialogTitle, title ); n++;

   dialDialog = XmCreateMessageDialog( __toplevel, "numberDialog", args, n);
   XmStringFree( label );
   XmStringFree( ok_b );
   XmStringFree( title );
   
   form = XtVaCreateManagedWidget( "numberForm",
      xmFormWidgetClass, dialDialog,
      NULL );
      
   dialog_contents = XtVaCreateManagedWidget( "numberRowColumn",
      xmRowColumnWidgetClass, form, 
      XmNnumColumns,       2,
      XmNpacking,          XmPACK_COLUMN,  
      XmNleftAttachment,   XmATTACH_FORM,  
      XmNrightAttachment,  XmATTACH_FORM,  
      XmNtopAttachment,      XmATTACH_POSITION,
      XmNtopPosition,        25,
      NULL );

   label = XmStringCreateSimple( "Number:" );
   XtVaCreateManagedWidget( "numberLabel",
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      NULL );
   XmStringFree( label );

   phone_field = XtVaCreateManagedWidget( "numberField",
      xmTextFieldWidgetClass, dialog_contents,
      XmNcolumns,          2,
      NULL );

   XtVaSetValues( XtParent(dialDialog),
      XmNmwmDecorations, MWM_DECOR_BORDER|MWM_DECOR_TITLE |MWM_DECOR_MENU,
      XmNmwmFunctions, MWM_FUNC_MOVE|MWM_FUNC_CLOSE,
      NULL );

   XtAddCallback( XtParent(dialDialog), XmNpopupCallback,
         dialDialogPopupCallback, NULL );
   XtAddCallback( dialDialog, XmNcancelCallback, dialDialogCancel, NULL );
   XtAddCallback( dialDialog, XmNunmapCallback, dialDialogCancel, NULL );
   XtAddCallback( dialDialog, XmNokCallback, dialDialogOk, NULL );
   XtAddCallback( dialDialog, XmNhelpCallback, displayHelpCallback, DialHelpString ); 
   
}

void dialDialogPopup()
{
   if( !XtIsManaged( dialDialog ) )
      XtManageChild( dialDialog );
   XtPopup( XtParent( dialDialog ), XtGrabNone );
}

void dialDialogPopdown()
{
   XtPopdown( XtParent( dialDialog ) );
}

static void dialDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( XtParent( dialDialog ) );
   dialogInfo.cancelCallback();
}

static void dialDialogOk( Widget w, XtPointer p1, XtPointer p2 )
{
   static char number[100];
   char* n;
   n = XmTextGetString( phone_field );
   if( strlen( n ) > 0 )
   {
      strcpy( number, n );
      XtFree( n );
      XtPopdown( XtParent( dialDialog ) );
      dialogInfo.dialCallback( number );
   }
}

static void dialDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 )
{
   int i;
   XmProcessTraversal( phone_field, XmTRAVERSE_CURRENT );
   i = XmTextGetLastPosition( phone_field );
   XmTextSetCursorPosition( phone_field, i );
}

void dialDialogInit( dialDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.dialCallback = info->dialCallback;
   if( info->number != NULL )
      XmTextFieldSetString( phone_field, info->number );
}

/*
 * EOF libui/motif/dialI.c
 */
