/*
 * $Id: dialingI.c,v 1.10 1998/02/17 09:52:38 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/dialingI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/MwmUtil.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>
#include <time.h>
#include <stdio.h>
#include <setjmp.h>

#include "libuiP.h"

static dialingDialogInfoRec dialogInfo;

static Widget dialingDialog;
static Widget number_field;
static Widget time_field;
static Widget attempt_field;
static time_t timer_counter;
static int    attempt = 0;
static XtIntervalId timeout = -1;

static void dialingDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void dialingDialogRetry( Widget w, XtPointer p1, XtPointer p2 );
static void dialingDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 );
static void dialingDialogPopdownCallback( Widget w, XtPointer p1, XtPointer p2 );
static void updateTime( XtPointer data, XtIntervalId* id );

void dialingDialogCreate()
{
   Widget dialog_contents,
          form,
          frame;
   XmString title, label, ok_b;
   Arg args[10];
   int n;
   
   label = XmStringCreateLocalized( "   Dial status:   ");
   title = XmStringCreateSimple( "Dialing...");
   ok_b  = XmStringCreateLocalized( " Retry " );
   
   n = 0;
   XtSetArg( args[n], XmNautoUnmanage, False ); n++;
   XtSetArg( args[n], XmNwidth, 335 ); n++;
   XtSetArg( args[n], XmNheight, 200 ); n++;
   XtSetArg( args[n], XmNmessageString, label ); n++;
   XtSetArg( args[n], XmNdialogTitle, title ); n++;
   XtSetArg( args[n], XmNokLabelString, ok_b ); n++;
   
   dialingDialog = XmCreateInformationDialog( __toplevel, "dialingDialog", args, n);
   XmStringFree( label );
   XmStringFree( title );
   

   frame = XtVaCreateManagedWidget( "dialingFrame",
      xmFrameWidgetClass, dialingDialog,
      NULL );

   form = XtVaCreateManagedWidget( "dialingForm", 
      xmFormWidgetClass, frame, 
      XmNbottomOffset,      20,
      XmNtopOffset,         20,
      NULL );
      
   dialog_contents = XtVaCreateManagedWidget( "dialogRowColumn",
      xmRowColumnWidgetClass, form, 
      XmNnumColumns,       2,
      XmNpacking,          XmPACK_COLUMN,  
      XmNorientation,      XmVERTICAL,
      XmNleftAttachment,   XmATTACH_POSITION,  
      XmNrightAttachment,  XmATTACH_POSITION,  
      XmNtopAttachment,      XmATTACH_POSITION,
      XmNleftPosition,      30,
      XmNrightPosition,      70,
      XmNtopPosition,      20,
      XmNisAligned,         False,
      NULL );

   label = XmStringCreateLocalized( "Number:" );   
   XtVaCreateManagedWidget( "dialingNumberLabel" , 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree(label);

   label = XmStringCreateLocalized( "Time:" );   
   XtVaCreateManagedWidget( "dialingTimeLabel" , 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree(label);

   label = XmStringCreateLocalized( "Attempt:" );
   XtVaCreateManagedWidget( "dialingAttemptLabel" , 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree(label);
   
   number_field = XtVaCreateManagedWidget( "dialingNumberValue",
      xmLabelWidgetClass, dialog_contents,
      XmNalignment, XmALIGNMENT_END,
      XmNlabelString, NULL,
      NULL );

   time_field = XtVaCreateManagedWidget( "dialingTimeValue",
      xmLabelWidgetClass, dialog_contents,
      XmNalignment, XmALIGNMENT_END,
      XmNlabelString, NULL,
      NULL );

   attempt_field = XtVaCreateManagedWidget( "dialingAttemptValue",
      xmLabelWidgetClass, dialog_contents,
      XmNalignment, XmALIGNMENT_END,
      XmNlabelString, NULL,
      NULL );

   XtVaSetValues( XtParent(dialingDialog),
      XmNmwmDecorations, MWM_DECOR_BORDER|MWM_DECOR_TITLE |MWM_DECOR_MENU,
      XmNmwmFunctions, MWM_FUNC_MOVE|MWM_FUNC_CLOSE,
      NULL );

   XtAddCallback( XtParent(dialingDialog), XmNpopupCallback, 
         dialingDialogPopupCallback, NULL );
   XtAddCallback( XtParent(dialingDialog), XmNpopdownCallback,
         dialingDialogPopdownCallback, NULL );

   XtAddCallback( dialingDialog, XmNcancelCallback, dialingDialogCancel, NULL );
   XtAddCallback( dialingDialog, XmNunmapCallback, dialingDialogCancel, NULL );
   XtAddCallback( dialingDialog, XmNokCallback, dialingDialogRetry, NULL );
   XtAddCallback( dialingDialog, XmNhelpCallback, displayHelpCallback, DialingHelpString ); 

}

void dialingDialogPopup()
{
   if( !XtIsManaged( dialingDialog ) )
      XtManageChild( dialingDialog );
   XtPopup( XtParent( dialingDialog ), XtGrabNone );
}

void dialingDialogPopdown()
{
   XtPopdown( XtParent( dialingDialog ) );
}

void dialingDialogInit( dialingDialogInfoRec* info )
{
   XmString xs;
   
   dialogInfo.cancelCallback  = info->cancelCallback;
   dialogInfo.timeoutCallback = info->timeoutCallback;
   dialogInfo.retryCallback   = info->retryCallback;
   dialogInfo.timeout = info->timeout;

   xs = XmStringCreateLocalized( info->number );
   XtVaSetValues( number_field, XmNlabelString, xs, NULL );
   XmStringFree( xs );
}

static void dialingDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( XtParent( dialingDialog ) );
   dialogInfo.cancelCallback();
}

static void dialingDialogRetry( Widget w, XtPointer p1, XtPointer p2 )
{
   dialogInfo.retryCallback();
}

static void dialingDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 )
{
   attempt = 0;
   dialingDialogReset();
   updateTime( NULL, NULL );
}

static void dialingDialogPopdownCallback( Widget w, XtPointer p1, XtPointer p2 )
{
   if( timeout != -1 )
      XtRemoveTimeOut( timeout );
   
}

void dialingDialogReset()
{
   char buf[20];
   XmString xs;
   timer_counter = dialogInfo.timeout;
   attempt++;
   sprintf( buf, "%d", attempt );
   xs = XmStringCreateLocalized( buf );
   XtVaSetValues( attempt_field, XmNlabelString, xs, NULL );
   XmStringFree( xs );
            
}

static void updateTime( XtPointer data, XtIntervalId* id )
{
   char buf[20];
   struct tm* tm;
   XmString xs;

   if( id != NULL )
      timer_counter--;
   if( timer_counter == 0 )
   {
      XtPopdown( XtParent( dialingDialog ) );
      dialogInfo.timeoutCallback();
      return;
   }
         
   tm = gmtime( &timer_counter );
   strftime( buf, sizeof(buf), "%M:%S", tm );
   
   xs = XmStringCreateLocalized( buf );
   XtVaSetValues( time_field, XmNlabelString, xs, NULL );
   XmStringFree( xs );
   timeout = XtAppAddTimeOut( AppContext, 1000, updateTime, NULL );
}

/*
 * EOF libui/motif/dialingI.c
 */
