/*
 * $Id: errorI.c,v 1.10 1998/02/17 09:52:39 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/errorI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <X11/Intrinsic.h>
#include <Xm/MessageB.h>
#include <Xm/MwmUtil.h>

#include "libuiP.h"

static Widget errorDialog;
static int errorDialogAnswer;

static void errorDialogResponse( Widget w, XtPointer p1, XtPointer p2 );

void errorDialogCreate()
{
   XmString title;
   Arg args[5];
   int n;
   
   title = XmStringCreateSimple( "Error:" );
   n = 0;
   XtSetArg( args[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL ); n++;
   XtSetArg( args[n], XmNdialogTitle, title ); n++;
   XtSetArg( args[n], XmNmessageAlignment, XmALIGNMENT_CENTER ); n++;
   errorDialog = XmCreateErrorDialog( __toplevel, "errorDialog", args, n );
   
   XmStringFree( title );
   XtUnmanageChild( XmMessageBoxGetChild( errorDialog, XmDIALOG_CANCEL_BUTTON) );

   XtVaSetValues( XtParent( errorDialog ),
      XmNmwmDecorations, MWM_DECOR_BORDER|MWM_DECOR_TITLE |MWM_DECOR_MENU,
      XmNmwmFunctions, MWM_FUNC_MOVE|MWM_FUNC_CLOSE,
      NULL );
   XtAddCallback( XtParent( errorDialog ), XmNpopdownCallback,
      errorDialogResponse, NULL );
   XtAddCallback( errorDialog, XmNhelpCallback, displayHelpCallback, ErrorHelpString ); 
   
}

void errorDialogPopup( char* msg )
{
   XmString xs;
   errorDialogCreate( __toplevel );
   
   xs = XmStringCreateLtoR( msg, XmFONTLIST_DEFAULT_TAG );
   XtVaSetValues( errorDialog, XmNmessageString, xs, NULL );
   XmStringFree( xs );
   
   errorDialogAnswer = 0;
   XtManageChild( errorDialog );
   XtPopup( XtParent( errorDialog ), XtGrabNone );

   /* Process only X events and Timer events */
   while( errorDialogAnswer == 0 || 
          XtAppPending( AppContext ) & (XtIMXEvent | XtIMTimer) )
      XtAppProcessEvent( AppContext, XtIMXEvent | XtIMTimer );

   XtDestroyWidget( errorDialog );
}

void errorDialogPopdown()
{
   XtPopdown( errorDialog );
}

static void errorDialogResponse( Widget w, XtPointer p1, XtPointer p2 )
{
   errorDialogAnswer = 1;
}
/*
 * EOF libui/motif/errorI.c
 */
