/*
 * $Id: interface.c,v 1.11 1998/02/17 09:52:39 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/interface.c,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <libhelp/libhelp.h>
#include "libuiP.h"

XtAppContext __app;
Display*     __dpy;
Widget       __toplevel;

static XtInputId interfaceInputId;
static int interfaceInputFd;
static int (*interfaceReadFuncPtr)(int) = NULL;

static void interfaceInputHandler( XtPointer clientData, 
                                   int* fd, XtInputId* id )
{  
   if( interfaceReadFuncPtr != NULL )
      if( interfaceReadFuncPtr( interfaceInputFd ) <= 0 )
         interfaceRemoveInput( interfaceInputFd );
}
      

void interfaceCreate( int* argc, char* argv[], const char* appName )
{
   __toplevel = XtVaAppInitialize(
      &__app, appName, NULL, 0,
      argc, argv,
      NULL,
      NULL
   );

   __dpy = XtDisplay( __toplevel );

                  
}

void interfaceSetInput( int fd, int (*readCallback)(int) )
{
   interfaceInputId = XtAppAddInput( AppContext, 
                  fd, 
                  (XtPointer)XtInputReadMask,
                  interfaceInputHandler,
                  NULL );
   interfaceInputFd = fd;
   interfaceReadFuncPtr = readCallback;
}

void interfaceRemoveInput( int fd )
{
   if( interfaceInputFd != fd )
      return;

   if( interfaceReadFuncPtr != NULL )
      XtRemoveInput( interfaceInputId );
   interfaceReadFuncPtr = NULL;
}

void interfaceRun()
{
   XtAppMainLoop( __app );
}

void displayHelpCallback( Widget w, XtPointer helpKey, XtPointer p2 )
{
   displayHelp( (char*)helpKey );
}

/*
 * EOF libui/motif/interface.c
 */
