/*
 * $Id: loginI.c,v 1.12 1998/02/17 09:52:41 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/loginI.c,v $
 * $Revision: 1.12 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/MwmUtil.h>
#include <Xm/MessageB.h>

#include "libuiP.h"

static Widget loginDialog;
static Widget user_field;
static Widget pw_field;

static char* passwd = NULL;

static loginDialogInfoRec dialogInfo;

static void loginDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void loginDialogOk( Widget w, XtPointer p1, XtPointer p2 );
static void loginDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 );
static void checkPasswd( Widget w, XtPointer, XtPointer );

void loginDialogCreate()
{
   Widget dialog_contents;
   XmString label, title;
   Arg args[10];
   int n;
   
   label = XmStringCreateLocalized( "   Please enter user name and password:   ");
   title = XmStringCreateSimple( "Login" );
   
   n = 0;
   XtSetArg( args[n], XmNautoUnmanage, False ); n++;
   XtSetArg( args[n], XmNmessageString, label ); n++;
   XtSetArg( args[n], XmNwidth, 335 ); n++;
   XtSetArg( args[n], XmNheight, 200 ); n++;
   XtSetArg( args[n], XmNdialogTitle, title ); n++;

   loginDialog = XmCreateQuestionDialog( __toplevel, "loginDialog", args, n);
   XmStringFree( label );
   XmStringFree( title );
      
   dialog_contents = XtVaCreateManagedWidget( "loginRowColumn",
      xmRowColumnWidgetClass, loginDialog, 
      XmNnumColumns,       2,
      XmNpacking,          XmPACK_COLUMN,  
      XmNleftAttachment,   XmATTACH_FORM,  
      XmNrightAttachment,  XmATTACH_FORM,  
      NULL );

   label = XmStringCreateSimple( "User:" );
   XtVaCreateManagedWidget( "loginUserLabel:" , 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      NULL );
   XmStringFree( label );
   
   label = XmStringCreateSimple( "Password:" );
   XtVaCreateManagedWidget( "loginPasswordLabel", 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      NULL );
   XmStringFree( label );

   user_field = XtVaCreateManagedWidget( "loginUserValue",
      xmTextFieldWidgetClass, dialog_contents,
      XmNcolumns,          2,
      NULL );

   pw_field = XtVaCreateManagedWidget( "loginPasswordField",
      xmTextFieldWidgetClass, dialog_contents,
      XmNcolumns,          2,
      NULL );

   XtVaSetValues( XtParent( loginDialog ),
      XmNmwmDecorations, MWM_DECOR_BORDER|MWM_DECOR_TITLE |MWM_DECOR_MENU,
      XmNmwmFunctions, MWM_FUNC_MOVE|MWM_FUNC_CLOSE,
      NULL );
   XtAddCallback( XtParent( loginDialog ), XmNpopupCallback,
      loginDialogPopupCallback, NULL );
   XtAddCallback( loginDialog, XmNcancelCallback, loginDialogCancel, NULL );
   XtAddCallback( loginDialog, XmNunmapCallback, loginDialogCancel, NULL );
   XtAddCallback( loginDialog, XmNokCallback, loginDialogOk, NULL );
   XtAddCallback( loginDialog, XmNhelpCallback, displayHelpCallback, LoginHelpString );

   XtAddCallback( pw_field, XmNmodifyVerifyCallback, checkPasswd, NULL );

}

void loginDialogInit( loginDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.okCallback = info->okCallback;

   if( info->user != NULL )
      XmTextFieldSetString( user_field, info->user );
   if( info->pw != NULL )
      XmTextFieldSetString( pw_field, info->pw );
}

static void loginDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 )
{
   int i;
   i = XmTextGetLastPosition( user_field );
   XmTextSetCursorPosition( user_field, i );
   if( i == 0 )
      XmProcessTraversal( user_field, XmTRAVERSE_CURRENT );
   else
      XmProcessTraversal( pw_field, XmTRAVERSE_CURRENT );
   i = XmTextGetLastPosition( pw_field );
   XmTextSetCursorPosition( pw_field, i );
}      
      
static void checkPasswd( Widget w, XtPointer p1, XtPointer call_data )
{
   char* new;
   int len;
   XmTextVerifyCallbackStruct* cbs;
   
   cbs = (XmTextVerifyCallbackStruct*)call_data;

   if( passwd == NULL )
      len = 0;
   else
      len = strlen( passwd );
   len -= cbs->endPos - cbs->startPos;
   len += cbs->text->length + 1;
   
   new = XtMalloc( len );
   if( passwd != NULL )
      strncpy( new, passwd, cbs->startPos );
   new[cbs->startPos] = '\0';
   if( cbs->text->length)
      strncat( new, cbs->text->ptr, cbs->text->length );
   new[cbs->startPos + cbs->text->length] = '\0';
   if( passwd != NULL )
      strcat( new, passwd + cbs->endPos );
   if( passwd != NULL )
      XtFree( passwd );
   passwd = new;

   for( len = 0; len < cbs->text->length; len++ )
      cbs->text->ptr[len] = '*';
}

void loginDialogPopup()
{
   if( !XtIsManaged( loginDialog ) )
      XtManageChild( loginDialog );
   XtPopup( XtParent( loginDialog ), XtGrabNone );
}

void loginDialogPopdown()
{
   XtPopdown( XtParent( loginDialog ) );
}

static void loginDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( XtParent( loginDialog ) );
   dialogInfo.cancelCallback();
}

static void loginDialogOk( Widget w, XtPointer p1, XtPointer p2 )
{
   static char  user[20];
   static char pw[20];
   char* u;
   int u_l = 0;
   int p_l = 0;
   
   u = XmTextGetString( user_field );
   if( u != NULL )
      u_l = strlen( u );
   if( passwd != NULL )
      p_l = strlen( passwd );

   if( u_l == 0 )
      return;
   
   if( p_l == 0 )
   {
      if( u_l > 0 )
         XtFree( u );
      return;
   }

   strncpy( user, u, sizeof(user));
   strncpy( pw,   passwd, sizeof(pw)  );
   XtFree( u );
   XtPopdown( XtParent( loginDialog ) );
   dialogInfo.okCallback( user, pw );  
}   

/*
 * EOF libui/motif/loginI.c
 */
