/*
 * $Id: loginMsgI.c,v 1.9 1998/02/17 09:52:41 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/loginMsgI.c,v $
 * $Revision: 1.9 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/MwmUtil.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>
#include <time.h>
#include <stdio.h>
#include <setjmp.h>

#include "libuiP.h"

static loginMsgDialogInfoRec dialogInfo;

static Widget loginMsgDialog;
static Widget user_field;
static Widget time_field;

static XtIntervalId timeout = -1;

static void loginMsgDialogCancel( Widget w, XtPointer p1, XtPointer p2 );
static void loginMsgDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 );
static void loginMsgDialogPopdownCallback( Widget w, XtPointer p1, XtPointer p2 );
static void updateTime( XtPointer data, XtIntervalId* id );

void loginMsgDialogCreate()
{
   Widget dialog_contents,
          form,
          frame;
   XmString title, label;
   Arg args[10];
   int n;
   
   label = XmStringCreateLocalized( "   Loging into the network:   ");
   title = XmStringCreateSimple( "Login...");
   
   n = 0;
   XtSetArg( args[n], XmNwidth, 335 ); n++;
   XtSetArg( args[n], XmNheight, 200 ); n++;
   XtSetArg( args[n], XmNmessageString, label ); n++;
   XtSetArg( args[n], XmNdialogTitle, title ); n++;
   
   XtSetArg( args[n], XmNautoUnmanage, False); n++;
   loginMsgDialog = 
      XmCreateInformationDialog( __toplevel, "loginMsgDialog", args, n);
   XmStringFree( label );
   XmStringFree( title );
   

   frame = XtVaCreateManagedWidget( "loginMsgFrame",
      xmFrameWidgetClass, loginMsgDialog,
      NULL );

   form = XtVaCreateManagedWidget( "loginMsgForm", 
      xmFormWidgetClass, frame, 
      XmNbottomOffset,      20,
      XmNtopOffset,         20,
      NULL );
      
   dialog_contents = XtVaCreateManagedWidget( "loginMsgRowColumn",
      xmRowColumnWidgetClass, form, 
      XmNnumColumns,       2,
      XmNpacking,          XmPACK_COLUMN,  
      XmNorientation,      XmVERTICAL,
      XmNleftAttachment,   XmATTACH_POSITION,  
      XmNrightAttachment,  XmATTACH_POSITION,  
      XmNtopAttachment,      XmATTACH_POSITION,
      XmNleftPosition,      30,
      XmNrightPosition,      70,
      XmNtopPosition,      20,
      XmNisAligned,         False,
      NULL );

   label = XmStringCreateLocalized( "User:" );   
   XtVaCreateManagedWidget( "loginMsgUserLabel" , 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree(label);

   label = XmStringCreateLocalized( "Time:" );   
   XtVaCreateManagedWidget( "loginMsgTimeLabel" , 
      xmLabelWidgetClass, dialog_contents,
      XmNlabelString, label,
      XmNalignment, XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree(label);
   
   user_field = XtVaCreateManagedWidget( "loginMsgUserValue",
      xmLabelWidgetClass, dialog_contents,
      XmNalignment, XmALIGNMENT_END,
      NULL );

   time_field = XtVaCreateManagedWidget( "loginMsgTimeValue",
      xmLabelWidgetClass, dialog_contents,
      XmNalignment, XmALIGNMENT_END,
      NULL );

   XtVaSetValues( XtParent(loginMsgDialog),
      XmNmwmDecorations, MWM_DECOR_BORDER|MWM_DECOR_TITLE |MWM_DECOR_MENU,
      XmNmwmFunctions, MWM_FUNC_MOVE|MWM_FUNC_CLOSE,
      NULL );

   XtUnmanageChild( XmMessageBoxGetChild( loginMsgDialog, XmDIALOG_OK_BUTTON ) );
   
   XtAddCallback( XtParent(loginMsgDialog), XmNpopupCallback, 
         loginMsgDialogPopupCallback, NULL );
   XtAddCallback( XtParent(loginMsgDialog), XmNpopdownCallback,
         loginMsgDialogPopdownCallback, NULL );
   XtAddCallback( loginMsgDialog, XmNcancelCallback, loginMsgDialogCancel, NULL );
   XtAddCallback( loginMsgDialog, XmNunmapCallback, loginMsgDialogCancel, NULL );
   XtAddCallback( loginMsgDialog, XmNhelpCallback,  displayHelpCallback, LoginMsgHelpString );
   
}

void loginMsgDialogPopup()
{
   if( !XtIsManaged( loginMsgDialog ) )
      XtManageChild( loginMsgDialog );
   XtPopup( XtParent( loginMsgDialog ), XtGrabNone );
}

void loginMsgDialogPopdown()
{
   XtPopdown( XtParent( loginMsgDialog ) );

}

void loginMsgDialogInit( loginMsgDialogInfoRec* info )
{
   XmString xs;
   
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.timeoutCallback = info->timeoutCallback;
   dialogInfo.timeout = info->timeout;
   xs = XmStringCreateLocalized( info->user );
   XtVaSetValues( user_field, XmNlabelString, xs, NULL );
   XmStringFree( xs );
   timeout = -1;
}

static void loginMsgDialogCancel( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( XtParent( loginMsgDialog ) );
   dialogInfo.cancelCallback();
}

static void loginMsgDialogPopupCallback( Widget w, XtPointer p1, XtPointer p2 )
{
   updateTime( NULL, NULL );

}

static void loginMsgDialogPopdownCallback( Widget w, XtPointer p1, XtPointer p2 )
{
   if( timeout != -1 )
      XtRemoveTimeOut( timeout );
   timeout = -1;
}

static void updateTime( XtPointer data, XtIntervalId* id )
{
   char buf[20];
   struct tm* tm;
   XmString xs;
   if( id != NULL )
      dialogInfo.timeout--;
   if( dialogInfo.timeout == 0 )
   {
      XtPopdown( XtParent( loginMsgDialog ) );
      dialogInfo.timeoutCallback();
      return;
   }
         
   tm = gmtime( &dialogInfo.timeout );
   strftime( buf, sizeof(buf), "%M:%S", tm );
   
   xs = XmStringCreateLocalized( buf );
   XtVaSetValues( time_field, XmNlabelString, xs, NULL );
   XmStringFree( xs );

   timeout = XtAppAddTimeOut( AppContext, 1000, updateTime, NULL );
}

/*
 * EOF libui/motif/loginMsgI.c
 */
