/*
 * $Id: statusI.c,v 1.10 1998/02/17 09:52:42 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/motif/statusI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>
#include <Xm/MwmUtil.h>
#include <stdio.h>
#include <time.h>
#include <fcntl.h>

#include "libuiP.h"
#define XtNledColor       "ledColor"
#define XtCledColor       "LedColor"
#define XtledDefaultColor "green"

typedef struct
{
   Pixel color_1;
   Pixel color_2;
} AppData;
static AppData appData;

static XtResource resources[] =
{
   {
      XtNledColor, XtCledColor, XmRPixel, sizeof(Pixel),
      XtOffsetOf( AppData, color_2), XtRString, XtledDefaultColor
   }
};

#define _READ_START 1
#define _READ_STOP  0

const int _READ_TIMEOUT = 500;
const int _TIMER_COUNT = 250;


#define INPUT_DONE      0x00
#define INPUT_STOPPED   0x01
#define INPUT_STARTED   0x02
#define INPUT_WORKING   0x04

typedef struct
{
   int         fd;
   int         status;
   unsigned    long bytes;
   XtInputId   input;
} inputRec;

static inputRec input[2];

static statusDialogInfoRec dialogInfo;

static Widget  statusDialog,
               led_read,
               led_write,
               bytes_read,
               bytes_write,
               connect_val,
               time_val;

static XtIntervalId connect_time = -1;

static Pixel colors[2];

static void startInput( XtPointer clientData, int* fd, XtInputId* id );
static void showBytes();
static void statusDialogPopupCallback( Widget dialog, XtPointer p1, XtPointer p2);
static void statusDialogPopdownCallback( Widget dialog, XtPointer p1, XtPointer p2);
static void updateTime( XtPointer data, XtIntervalId* id );
static void statusDialogDisconnect( Widget, XtPointer, XtPointer );
static void setIndicator( int fd, int startRead );
static void doColors();

void statusDialogPopup()
{
   if( !XtIsManaged( statusDialog ) )
      XtManageChild( statusDialog );
   XtPopup( XtParent( statusDialog ), XtGrabNone );
}

void statusDialogPopdown()
{
   XtPopdown( XtParent( statusDialog ) );
}
   
void statusDialogCreate()
{
   Widget data,
          frame1,
          frame2,
          frame3,
          leds,
          transfer_info,
          label_read,
          label_write,
          info,
          connect_string,
          time_string;

   XmString title, label;
   Arg args[10];
   int n;   
   title = XmStringCreateSimple( "Connect" );
   label = XmStringCreateLocalized( " Disconnect " );

   n = 0;
   XtSetArg( args[n], XmNdialogTitle, title ); n++;
   XtSetArg( args[n], XmNcancelLabelString, label ); n++;

   statusDialog = XmCreateMessageDialog( __toplevel, "statusDialog", args, n );

   XmStringFree( title );
   XmStringFree( label );
   
   data = XtVaCreateManagedWidget( "statusDataRowColumn",
      xmRowColumnWidgetClass, statusDialog,
      XmNnumColumns,         2,
      XmNorientation,      XmHORIZONTAL,
      NULL );

   frame1 = XtVaCreateManagedWidget( "statusFrame1",
      xmFrameWidgetClass,    data,
      NULL );

   frame2 = XtVaCreateManagedWidget( "statusFrame2",
      xmFrameWidgetClass,    data,
      NULL );

   frame3 = XtVaCreateManagedWidget( "statusFrame3",
      xmFrameWidgetClass,    data,
      NULL );
   
   leds = XtVaCreateManagedWidget( "statusLeds",
      xmFormWidgetClass,    frame1,
      NULL );

   led_read = XtVaCreateManagedWidget( "sta",
      xmFrameWidgetClass,    leds,
      XmNwidth,            20,
      XmNtopAttachment,      XmATTACH_FORM,
      XmNbottomAttachment,   XmATTACH_POSITION,
      XmNbottomPosition,   50,
      NULL );
   led_write = XtVaCreateManagedWidget( "sta",
      xmFrameWidgetClass,   leds,
      XmNwidth,            20,
      XmNtopAttachment,      XmATTACH_POSITION,
      XmNbottomAttachment,   XmATTACH_FORM,
      XmNtopPosition,      50,
      NULL );
   
   transfer_info = XtVaCreateManagedWidget( "statusTransferInfo",
      xmRowColumnWidgetClass,   frame2,
      XmNnumColumns,         2,
      XmNpacking,            XmPACK_COLUMN,
      XmNorientation,      XmHORIZONTAL,
      XmNisAligned,         False,
      NULL );

   label = XmStringCreateLocalized( "Received:" );
   label_read = XtVaCreateManagedWidget( "statusReadLabel",
      xmLabelWidgetClass,   transfer_info,
      XmNlabelString,      label,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree( label );
   
   label = XmStringCreateLocalized( "0" );
   bytes_read = XtVaCreateManagedWidget( "statusReadValue",
      xmLabelWidgetClass,   transfer_info,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      XmNlabelString,      label,
      NULL );
   XmStringFree( label );


   label  = XmStringCreateLocalized( "Sent:" );
   label_write = XtVaCreateManagedWidget( "statusSentLabel",
      xmLabelWidgetClass,   transfer_info,
      XmNlabelString,      label,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree( label );
      
     label = XmStringCreateLocalized( "0" );
   bytes_write = XtVaCreateManagedWidget( "statusSentValue",
      xmLabelWidgetClass,   transfer_info,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      XmNlabelString,      label,
      NULL );
   XmStringFree( label );
   
   info = XtVaCreateManagedWidget( "statusInfo",
      xmRowColumnWidgetClass, frame3,
      XmNnumColumns,         2,
      XmNpacking,            XmPACK_COLUMN,
      XmNorientation,      XmHORIZONTAL,
      XmNisAligned,         False,
      NULL );

   label = XmStringCreateLocalized( "Connect:" );
   connect_string = XtVaCreateManagedWidget( "statusConnectLabel",
      xmLabelWidgetClass,   info,
      XmNlabelString,      label,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree( label );
   
   label = XmStringCreateLocalized( "28800 bps" );   
   connect_val = XtVaCreateManagedWidget( "statusConnectValue",
      xmLabelWidgetClass,   info,
      XmNlabelString,      label,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree( label );
   
   label = XmStringCreateLocalized( "Time:" );
   time_string = XtVaCreateManagedWidget( "statusTimeLabel",
      xmLabelWidgetClass,   info,
      XmNlabelString,      label,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree( label );
   
   label = XmStringCreateLocalized( "00:00:00" );   
   time_val = XtVaCreateManagedWidget( "statusTimeValue",
      xmLabelWidgetClass,   info,
      XmNlabelString,      label,
      XmNalignment,         XmALIGNMENT_BEGINNING,
      NULL );
   XmStringFree( label );
   
   XtUnmanageChild( XmMessageBoxGetChild( statusDialog, XmDIALOG_OK_BUTTON ) );

   XtAddCallback( XtParent(statusDialog), XmNpopupCallback,
         statusDialogPopupCallback, NULL );
   XtAddCallback( XtParent(statusDialog), XmNpopdownCallback,
         statusDialogPopdownCallback, NULL );
   XtAddCallback( statusDialog, XmNcancelCallback, statusDialogDisconnect, NULL );
   XtAddCallback( statusDialog, XmNunmapCallback, statusDialogDisconnect, NULL );
   XtAddCallback( statusDialog, XmNhelpCallback, displayHelpCallback, StatusHelpString );
     
   
   
   
   XtVaSetValues( XtParent( statusDialog ),
      XmNmwmDecorations,    MWM_DECOR_BORDER |
                           MWM_DECOR_TITLE  |
                           MWM_DECOR_MENU   |
                           MWM_DECOR_MINIMIZE,
      XmNmwmFunctions,      MWM_FUNC_MOVE    |
                           MWM_FUNC_CLOSE   |
                           MWM_FUNC_MINIMIZE,
      NULL );
      
   doColors();
   XtVaSetValues( led_read, XmNbackground, colors[0], NULL );
   XtVaSetValues( led_write, XmNbackground, colors[0], NULL );
      
}

static void doColors()
{
   XtGetApplicationResources( statusDialog,
      &appData,
      resources, XtNumber( resources ),
      NULL, 0 );
   colors[1] = appData.color_2;   
   XtVaGetValues( statusDialog, XmNbackground, &colors[0], NULL );
}
   
static void statusDialogDisconnect( Widget w, XtPointer p1, XtPointer p2 )
{
   XtPopdown( XtParent( statusDialog ) );
   dialogInfo.disconnectCallback();
}

void statusDialogInit( statusDialogInfoRec* info )
{
   XmString xs;
   char buf[100];

   input[0].fd = info->fd1;
   input[1].fd = info->fd2;
   dialogInfo.readCallback = info->readCallback;
   dialogInfo.timeCallback = info->timeCallback;
   dialogInfo.disconnectCallback = info->disconnectCallback;

   sprintf( buf, "%s bps", info->connectSpeed );
   xs  = XmStringCreateLocalized( buf );
   XtVaSetValues( connect_val, XmNlabelString, xs, NULL );
   XmStringFree( xs );   

   sprintf( buf, "Connected to %s", info->connectedTo );
   xs  = XmStringCreateLocalized( buf );
   XtVaSetValues( statusDialog, XmNdialogTitle, xs, NULL );
   XmStringFree( xs );   

   input[0].bytes = input[1].bytes = 0;
}

static void statusDialogPopupCallback( Widget dialog, XtPointer p1, XtPointer p2)
{
   input[0].input = XtAppAddInput( AppContext, input[0].fd, 
            (XtPointer)XtInputReadMask,
            startInput,
            NULL );
   input[1].input = XtAppAddInput( AppContext, input[1].fd,
            (XtPointer)XtInputReadMask,
            startInput,
            NULL );
   input[0].status = input[1].status = INPUT_DONE;
   
   connect_time = XtAppAddTimeOut( AppContext, _TIMER_COUNT, updateTime, NULL );
}

static void updateTime( XtPointer data, XtIntervalId* id )
{
   time_t time;
   static int fract = 1;
   char buf[100];
   XmString xs;
   struct tm* tm;
   int i;
   int show_bytes = 0;

   connect_time = XtAppAddTimeOut( AppContext, _TIMER_COUNT, updateTime, NULL );
   
   if( fract * _TIMER_COUNT >= 1000 )
   {
      time = dialogInfo.timeCallback();
      tm = gmtime( &time );
      strftime( buf, sizeof(buf), "%H:%M:%S", tm );
      xs = XmStringCreateLocalized( buf );
      XtVaSetValues( time_val, XmNlabelString, xs, NULL );
      XmStringFree( xs );
      fract = 1;
   }
   else
      fract++;

   for( i = 0; i<2; i++ )
   switch( input[i].status )
   {
      case INPUT_STOPPED:
         setIndicator( input[i].fd, _READ_STOP );
         input[i].status = INPUT_DONE;
         break;
      case INPUT_WORKING:
         show_bytes = 1;
      case INPUT_STARTED:
         input[i].status = INPUT_STOPPED;
         break;
   }
   if( show_bytes )
      showBytes();
}   
   
static void statusDialogPopdownCallback( Widget dialog, XtPointer p1, XtPointer p2)
{
   XtRemoveInput( input[0].input );
   XtRemoveInput( input[1].input );
   if( connect_time != -1 )
      XtRemoveTimeOut( connect_time );
}

static void setIndicator( int fd, int startRead )
{
   Widget w;
   if( fd == input[0].fd )
      w = led_read;
   else
   if( fd == input[1].fd )
      w = led_write;
   else
      return;

   XtVaSetValues( w, XmNbackground, colors[startRead], NULL );
}

static void startInput( XtPointer clientData, int* fd, XtInputId* id )
{
   int result;
   int i;
   
   if( *id == input[0].input )
      i = 0;
   else
      i = 1;

   
   if( input[i].status == INPUT_DONE  )
   {
      input[i].status = INPUT_STARTED;
      setIndicator( input[i].fd, _READ_START );
   }
   else
      input[i].status = INPUT_WORKING;

   result = dialogInfo.readCallback( input[i].fd );

   if( result > 0 )
      input[i].bytes += result;
   else
   if( result == 0 )
      XtRemoveInput( input[i].input ); 
   if( input[i].status == INPUT_STARTED )
      showBytes();
}


static void showBytes()
{
   char buf[100];
   XmString xs;
   
   if( input[0].status != INPUT_DONE )
   {
      sprintf( buf, "%ld", input[0].bytes );
      xs = XmStringCreateLocalized( buf );
      XtVaSetValues( bytes_read, XmNlabelString, xs, NULL );
      XmStringFree( xs );
   }
   if( input[1].status != INPUT_DONE )
   {
      sprintf( buf, "%ld", input[1].bytes );
      xs = XmStringCreateLocalized( buf );
      XtVaSetValues( bytes_write, XmNlabelString, xs, NULL );
      XmStringFree( xs );
   }
}

/*
 * EOF libui/motif/statusI.c
 */
