/*
 * $Id: dialI.c,v 1.3 1998/02/17 09:52:43 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/text/dialI.c,v $
 * $Revision: 1.3 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
 
#include <libui/libui.h>

static dialDialogInfoRec dialogInfo;

void dialDialogCreate()
{
   /* Empty for text interface */  
}

void dialDialogPopup()
{
   char number[512];

   /* Prompt user to enter phone number ... */
   fprintf( stdout, "Phone number: " );
   fflush( stdout );
   
   /* ... and read number from stdin */
   fgets( number, sizeof( number ) - 1, stdin );

   /* instruct modem software to dial this number */
   dialogInfo.dialCallback( number );
}

void dialDialogInit( dialDialogInfoRec* info )
{
   /* Only set dialCallback */
   dialogInfo.dialCallback   = info->dialCallback;
}

/*
 * EOF libui/text/dialI.c
 */
