/*
 * $Id: dialingI.c,v 1.4 1998/02/17 09:52:44 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/text/dialingI.c,v $
 * $Revision: 1.4 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include <libui/libui.h>
#include <liberror/liberror.h>

static dialingDialogInfoRec dialogInfo;

/* Save sigaction for SIGALRM */
static struct sigaction savedSigAlrm;

void dialingDialogCreate()
{
   /* Empty for text interface */
}

/* ARGUSED */
static void alarmed( int sig )
{
   fprintf( stderr, "timeout\n" );
   exit( 1 );
}

void dialingDialogPopup()
{
   struct sigaction act;

   act.sa_handler = alarmed;
   
   sigemptyset( &act.sa_mask );
   act.sa_flags = 0;

   /* Save current signal handler and set new handler for SIGALRM */
   if( sigaction( SIGALRM, &act, &savedSigAlrm ) == -1 )
   {
      FAIL( "sigaction" );
      exit( 1 );
   }
 
   /* Set alarm */
   alarm( dialogInfo.timeout );
}

void dialingDialogPopdown()
{
   /* Remove alarm */
   alarm( 0 );

   /* Restore signal handler for SIGALRM */
   sigaction( SIGALRM, &savedSigAlrm, NULL );
}

void dialingDialogInit( dialingDialogInfoRec* info )
{
   dialogInfo.timeoutCallback = info->timeoutCallback;
   dialogInfo.timeout = info->timeout;

   if( dialogInfo.number != NULL )
      free( dialogInfo.number );

   dialogInfo.number = strdup( info->number );
}

void dialingDialogReset()
{
   /* Empty for text interface */
}
/*
 * EOF libui/text/dialingI.c
 */
