/*
 * $Id: interface.c,v 1.5 1998/02/17 09:52:45 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/text/interface.c,v $
 * $Revision: 1.5 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>

#include <liberror/liberror.h>
#include <libui/libui.h>

typedef struct
{
   int fd;
   int (*interfaceReadFuncPtr)(int);
} input_struct;

static input_struct interfaceInput[2];

/* ARGUSED */
void interfaceCreate( int* argc, char* argv[], const char* appName )
{
   interfaceInput[0].fd = -1;
   interfaceInput[1].fd = -1;
}

void interfaceSetInput( int fd, int (*readCallback)(int) )
{
   int i;
   
   if( interfaceInput[0].fd == -1 )
      i = 0;
   else
      i = 1;
   interfaceInput[i].fd = fd;
   interfaceInput[i].interfaceReadFuncPtr = readCallback;
   
}

void interfaceRemoveInput( int fd )
{
   int i;
   i = -1;
   
   if( interfaceInput[0].fd == fd )
      i = 0;
   else
   if( interfaceInput[1].fd == fd )
      i = 1;
   
   if( i != -1 )
      interfaceInput[i].fd = -1;      
}

void interfaceRun()
{
   fd_set fds;
   int    result;
   
   while( 1 )
   {
      FD_ZERO( &fds );
      if( interfaceInput[0].fd != -1 )
      {
         FD_SET( interfaceInput[0].fd, &fds );
      }
      if( interfaceInput[1].fd != -1 )
      {
         FD_SET( interfaceInput[1].fd, &fds );
      }
      result = select( FD_SETSIZE, &fds, NULL, NULL, NULL );
      if( result < 0 )
      {
         FAIL( "select" );
         exit( 1 );
      }

      if( interfaceInput[0].fd != -1 &&
          FD_ISSET( interfaceInput[0].fd, &fds ) )
      {
         interfaceInput[0].interfaceReadFuncPtr( interfaceInput[0].fd );
      }

      if( interfaceInput[1].fd != -1 && 
          FD_ISSET( interfaceInput[1].fd, &fds ) )
      {
         interfaceInput[1].interfaceReadFuncPtr( interfaceInput[1].fd );
      }
      
   }
}
   
/*
 * EOF libui/text/interface.c
 */
