/*
 * $Id: loginI.c,v 1.5 1998/02/17 09:52:46 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/text/loginI.c,v $
 * $Revision: 1.5 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>

#include <libui/libui.h>
#include <liberror/liberror.h>

static loginDialogInfoRec dialogInfo;

void loginDialogCreate()
{
   /* empty for text interface */
}

void loginDialogInit( loginDialogInfoRec* info )
{
   dialogInfo.okCallback = info->okCallback;

}
      
void loginDialogPopup()
{
   char   login[100];
   char   pw[100];
   struct termios attr;
      
   /* prompt for login and read user name from standard input */
   fprintf( stdout, "Login: " );
   fflush( stdout );
   fgets( login, sizeof( login ) - 1, stdin );
   
   /* prompt for password */
   fprintf( stdout, "Password: " );
   fflush( stdout );
   
   /* Save terminal settings */
   if( tcgetattr( STDIN_FILENO, &attr ) != 0 )
   {
      FAIL( "tcgetattr" );
      exit( 1 );
   }
   
   /* Turn off local echo */
   attr.c_lflag &= ~(ECHO);
   if( tcsetattr( STDIN_FILENO, TCSAFLUSH, &attr ) != 0 )
   {
      FAIL( "tcsetattr" );
      exit( 1 );
   }

   /* Get password */
   fgets( pw, sizeof( pw ) - 1, stdin );
   
   /* Turn on local echo */
   attr.c_lflag |= ECHO;
   if( tcsetattr( STDIN_FILENO, TCSANOW, &attr ) != 0 )
   {
      FAIL( "tcsetattr" );
      exit( 1 );
   }
   
   fprintf( stdout, "\n" );
   
   /* Instruct login program to continue */
   dialogInfo.okCallback( login, pw );
}

/*
 * EOF libui/text/loginI.c
 */
