/*
 * $Id: statusI.c,v 1.4 1998/02/17 09:52:47 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/text/statusI.c,v $
 * $Revision: 1.4 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <time.h>
#include <fcntl.h>

#include <libui/libui.h>

typedef struct
{
   int         fd;
} inputRec;

static inputRec input[2];

static statusDialogInfoRec dialogInfo;

void statusDialogPopup()
{
   interfaceSetInput( input[0].fd, dialogInfo.readCallback );
   interfaceSetInput( input[1].fd, dialogInfo.readCallback );
}

void statusDialogPopdown()
{
   interfaceRemoveInput( input[0].fd );
   interfaceRemoveInput( input[1].fd );   
}
   
void statusDialogCreate()
{
   /* empty for text interface */
}

void statusDialogInit( statusDialogInfoRec* info )
{
   input[0].fd = info->fd1;
   input[1].fd = info->fd2;

   dialogInfo.readCallback = info->readCallback;
}

/*
 * EOF libui/text/statusI.c
 */
