#
# $Id: dial.tcl,v 1.9 1998/02/17 09:52:48 mdejonge Exp $
#
#   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/dial.tcl,v $
# $Revision: 1.9 $
#    Author: Merijn de Jonge
#     Email: mdejonge@wins.uva.nl
# 
#  
# 
# This file is part of the modem communication package.
# Copyright (C) 1996-1998  Merijn de Jonge
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
# 
#
wm withdraw .

set phone_number ""
set tk_strictMotif  1

proc dial-dialog-create {} {
   set w .dial-dialog
   
   toplevel    $w -class Dialog
   wm title    $w "Phone Number"
   wm iconname $w "Phone Number"
   
   frame $w.top -relief raised -bd 1
   frame $w.bot -relief raised -bd 1
   
   message $w.top.msg \
      -justify left \
      -width 10i \
      -text "Please enter phone number to dial:"
   
   frame $w.top.input

   label $w.top.input.label \
      -text "Number:"
   entry $w.top.input.entry \
      -textvariable phone_number
      
   pack $w.top.input.label \
      -side left \
      -fill y
   pack $w.top.input.entry \
      -side left \
      -fill both \
      -expand 1
   pack $w.top.msg \
           -side top \
           -expand 1 \
           -padx 2m \
           -pady 5m \
           -anchor w

   pack $w.top.input \
           -side top \
           -expand 1 \
           -fill x \
           -padx 2m \
           -pady 5m\
           -anchor w

   button $w.bot.dial \
      -text " Dial " \
      -command dial-callback
   button $w.bot.cancel \
      -text " Cancel " \
      -command cancel-callback
   button $w.bot.help \
      -text " Help " \
      -command "help dial"
   pack $w.bot.dial\
        $w.bot.cancel \
        $w.bot.help \
           -side left \
           -expand 1 \
           -padx 2m \
           -pady 2m
           

   pack $w.top \
           -side top \
           -fill both \
           -expand 1
   
   pack $w.bot \
           -side top \
           -fill both \
           -expand 1
   wm withdraw $w
}

proc dial-callback {} {
   global phone_number
   dial-dial $phone_number
}

proc cancel-callback {} {
   dial-cancel
}

proc dial-dialog-init {number} {
   global phone_number
   
   set phone_number $number
}

proc dial-dialog-popup {} {
   wm deiconify .dial-dialog
}

proc dial-dialog-popdown {} {
   wm withdraw .dial-dialog
}

#
# EOF libui/tk/dial.tcl
#
