/*
 * $Id: dialI.c,v 1.10 1998/02/17 09:52:49 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/dialI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libuiP.h"
#include "dial.h"

static dialDialogInfoRec dialogInfo;

void dialDialogCreate()
{
   Tcl_Eval( interp, window );
   Tcl_VarEval( interp, "dial-dialog-create", NULL );
}

int DialCancelCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.cancelCallback();
   dialDialogPopdown();
   interp->result = "0";
   return TCL_OK;
}

int DialDialCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.dialCallback( argv[1] );
   dialDialogPopdown();
   interp->result = "0";
   return TCL_OK;
}

void dialDialogInit( dialDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.dialCallback   = info->dialCallback;
   Tcl_VarEval( interp, "dial-dialog-init ", info->number, NULL );

   Tcl_CreateCommand( interp, "dial-cancel", DialCancelCmd, NULL, NULL );
   Tcl_CreateCommand( interp, "dial-dial", DialDialCmd, NULL, NULL );
   
}

void dialDialogPopup()
{
   Tcl_VarEval( interp, "dial-dialog-popup", NULL );
}

void dialDialogPopdown()
{
   Tcl_VarEval( interp, "dial-dialog-popdown", NULL );
}

   
/*
 * EOF libui/tk/dialI.c
 */
