#
# $Id: dialing.tcl,v 1.9 1998/02/17 09:52:50 mdejonge Exp $
#
#   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/dialing.tcl,v $
# $Revision: 1.9 $
#    Author: Merijn de Jonge
#     Email: mdejonge@wins.uva.nl
# 
#  
# 
# This file is part of the modem communication package.
# Copyright (C) 1996-1998  Merijn de Jonge
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
# 
#
wm withdraw .

set number   "4211545"
set attempt  "1"
set time_str "00:00"
set time     0
set elapsed  0

proc dialing-dialog-create {} {
   set w .dialing-dialog
   
   toplevel    $w -class Dialog
   wm title    $w "Dialing..."
   wm iconname $w "Dialing..."

   frame $w.top -relief raised -bd 1
   frame $w.bot -relief raised -bd 1
   
   frame $w.top.msg
   label $w.top.msg.bitmap -bitmap info
   message $w.top.msg.msg \
              -text "Dial status:" \
              -justify left \
              -width 10i
   pack $w.top.msg.bitmap $w.top.msg.msg \
      -side left \
      -padx 4m
   
   frame $w.top.data \
      -relief groove \
      -bd 2
    
   frame $w.top.data.labels
   frame $w.top.data.values
   
   label $w.top.data.labels.number  -text "Number:"  -justify left
   label $w.top.data.labels.time    -text "Time:"    -justify left
   label $w.top.data.labels.attempt -text "Attempt:" -justify left
   pack $w.top.data.labels.number \
        $w.top.data.labels.time \
        $w.top.data.labels.attempt \
           -side top \
           -expand 1 \
           -anchor w

  label $w.top.data.values.number  -textvariable number   -justify left
  label $w.top.data.values.time    -textvariable time_str -justify left
  label $w.top.data.values.attempt -textvariable attempt  -justify left
  pack $w.top.data.values.number \
       $w.top.data.values.time \
       $w.top.data.values.attempt \
          -side top \
          -expand 1 \
          -anchor w
   pack $w.top.data.labels \
        $w.top.data.values \
           -side left \
           -expand 1

   pack $w.top.msg \
        $w.top.data \
           -side top \
           -expand 1 \
           -fill both \
           -pady 5m \
           -padx 5m

   button $w.bot.retry \
      -text " Retry " \
      -command dialing-dialog-retry-callback
   button $w.bot.cancel \
      -text " Cancel " \
      -command dialing-dialog-cancel-callback
   button $w.bot.help \
      -text " Help " \
      -command "help dialing"
   pack $w.bot.retry\
        $w.bot.cancel \
        $w.bot.help \
           -side left \
           -expand 1 \
           -padx 2m \
           -pady 2m
 

   pack $w.top \
        $w.bot \
           -side top \
           -expand 1 \
           -fill both
   wm withdraw $w
}

proc dialing-dialog-retry-callback {} {

   dialing-retry
}

proc dialing-dialog-cancel-callback {} {
   dialing-cancel
}

proc dialing-dialog-timeout-callback {} {
   dialing-timeout
}


proc dialing-dialog-init {_number _time} {
   global number time attempt time_str
   set number  $_number
   set time    $_time
   
   set time_str [clock format $time  -format "%M:%S" -gmt 1]
}

proc dialing-dialog-update_time {} {
   global time time_str elapsed
   incr elapsed
      
   set count [expr $time - $elapsed]
   
   set time_str [clock format $count  -format "%M:%S" -gmt 1]
   if {$count == 0} {
      dialing-dialog-timeout-callback
      return
   }
   after 1000 {dialing-dialog-update_time}
}

proc dialing-dialog-reset {} {
   global attempt elapsed time_str time

   incr attempt
   set elapsed 0

   set count [expr $time - $elapsed]
   set time_str [clock format $count  -format "%M:%S" -gmt 1]
}

proc dialing-dialog-popup {} {
   wm deiconify .dialing-dialog
   after 1000  dialing-dialog-update_time
}

proc dialing-dialog-popdown {} {
   wm withdraw .dialing-dialog
   after cancel dialing-dialog-update_time
}

#
# EOF libui/tk/dialing.tcl
#
