/*
 * $Id: dialingI.c,v 1.10 1998/02/17 09:52:50 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/dialingI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libuiP.h"
#include "dialing.h"

static dialingDialogInfoRec dialogInfo;

void dialingDialogCreate()
{
   Tcl_Eval( interp, window );
   Tcl_VarEval( interp, "dialing-dialog-create", NULL );
}

int DialingRetryCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.retryCallback();
   interp->result = "0";
   return TCL_OK;
}

int DialingCancelCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.cancelCallback();
   interp->result = "0";
   return TCL_OK;
}

int DialingTimeoutCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.timeoutCallback();
   interp->result = "0";
   return TCL_OK;
}

void dialingDialogInit( dialingDialogInfoRec* info )
{
   char timeout[20];
   
   dialogInfo.cancelCallback  = info->cancelCallback;
   dialogInfo.timeoutCallback = info->timeoutCallback;
   dialogInfo.retryCallback   = info->retryCallback;
   
   sprintf( timeout, "%ld", info->timeout );
   Tcl_VarEval( interp, "dialing-dialog-init ",
      info->number, " ", timeout, NULL );
   Tcl_CreateCommand( interp, "dialing-retry", DialingRetryCmd, NULL, NULL );
   Tcl_CreateCommand( interp, "dialing-cancel", DialingCancelCmd, NULL, NULL );
   Tcl_CreateCommand( interp, "dialing-timeout", DialingTimeoutCmd, NULL, NULL );
}

void dialingDialogPopup()
{
   Tcl_VarEval( interp, "dialing-dialog-popup", NULL );   
}

void dialingDialogPopdown()
{
   Tcl_VarEval( interp, "dialing-dialog-popdown", NULL );   
}

void dialingDialogReset()
{
   Tcl_VarEval( interp, "dialing-dialog-reset", NULL );
}
 
/*
 * EOF libui/tk/dialingI.c
 */
