#
# $Id: error.tcl,v 1.10 1998/02/17 09:52:51 mdejonge Exp $
#
#   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/error.tcl,v $
# $Revision: 1.10 $
#    Author: Merijn de Jonge
#     Email: mdejonge@wins.uva.nl
# 
#  
# 
# This file is part of the modem communication package.
# Copyright (C) 1996-1998  Merijn de Jonge
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
# 
#
wm withdraw .

set error_msg ""
set error_ok  ""

proc error-dialog-create {} {
   set w .error-dialog
   
   toplevel    $w -class Dialog
   wm title    $w "Error..."
   wm iconname $w "Error..."

   frame $w.top -relief raised -bd 1
   frame $w.bot -relief raised -bd 1
   
   label $w.top.bitmap -bitmap error
   message $w.top.msg \
              -textvariable error_msg \
              -justify center \
              -width 10i
   pack $w.top.bitmap $w.top.msg \
      -side left \
      -padx 4m \
      -pady 5m
   
   button $w.bot.ok \
      -text " OK " \
      -command error-dialog-ok-callback
   button $w.bot.help \
      -text " Help " \
      -command "help error"

   pack $w.bot.ok \
        $w.bot.help \
           -side left \
           -expand 1 \
           -padx 2m \
           -pady 2m
 
   pack $w.top \
        $w.bot \
           -side top \
           -expand 1 \
           -fill both
   wm withdraw $w
}

proc error-dialog-ok-callback {} {
   global error-ok
   set error-ok 1
   error-dialog-popdown
}


proc error-dialog-init {msg} {
   global error_msg
   set error_msg $msg
}

proc error-dialog-popup {} {
   global error-ok
   wm deiconify .error-dialog
   grab .error-dialog
   waitvar error-ok
}

proc error-dialog-popdown {} {
   grab release .error-dialog
   wm withdraw .error-dialog
}

#
# EOF libui/tk/error.tcl
#
