/*
 * $Id: errorI.c,v 1.11 1998/02/17 09:52:51 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/errorI.c,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libuiP.h"
#include "error.h"
/*
 * Used by Tk_TkmywaitCmd to set clientData to 1 when
 * a tcl/tk variable has been modified.
 * Inspired on WaitVariableProc from Tcl/Tk distribution.
 */
static char *
VariableChanged( ClientData clientData, Tcl_Interp* interp,
    char* name1, char* name2,
    int flags )
{
    int *done = (int *)clientData;

    *done = 1;
    return NULL;
}


/*
 * This procedure which is based on Tk_TkwaitCmd from
 * the Tk distribution waits until the state of a variable
 * has changed but it will process only X events and Timer
 * events
 */
int WaitvarCmd( clientData, interp, argc, argv)
    ClientData clientData;      /* Main window associated with
                                 * interpreter. */
    Tcl_Interp *interp;         /* Current interpreter. */
    int argc;                   /* Number of arguments. */
    char **argv;                /* Argument strings. */
{
   int       done;
   Tk_Window tkwin;

   tkwin = (Tk_Window) clientData;

   if (argc != 2)
   {
      Tcl_AppendResult( interp, "wrong # args: should be \"",
         argv[0], " name\"", (char *) NULL );
      return TCL_ERROR;
   }

   if( Tcl_TraceVar( interp, argv[1],
          TCL_GLOBAL_ONLY | TCL_TRACE_WRITES | TCL_TRACE_UNSETS,
          VariableChanged, (ClientData) &done) 
       != TCL_OK )
   {
      return TCL_ERROR;
   }

   done = 0;
   while (!done)
   {
      Tcl_DoOneEvent( TK_X_EVENTS | TK_TIMER_EVENTS | TK_IDLE_EVENTS );
   }

   Tcl_UntraceVar( interp, argv[1],
      TCL_GLOBAL_ONLY | TCL_TRACE_WRITES | TCL_TRACE_UNSETS,
      VariableChanged, (ClientData) &done );

   Tcl_ResetResult( interp );
   return TCL_OK;
}


void errorDialogCreate()
{
   Tcl_CreateCommand( interp, "waitvar",
      WaitvarCmd, NULL, NULL );
   Tcl_Eval( interp, window );
   Tcl_VarEval( interp, "error-dialog-create", NULL );
}

void errorDialogPopup( char* msg )
{
   Tcl_VarEval( interp, "error-dialog-init {", msg, "}", NULL );
   Tcl_VarEval( interp, "error-dialog-popup", NULL );
}

void errorDialogPopdown()
{
   Tcl_VarEval( interp, "error-dialog-popdown", NULL );
}   


/*
 * EOF libui/tk/errorI.c
 */
