/*
 * $Id: interface.c,v 1.15 1998/02/17 09:52:52 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/interface.c,v $
 * $Revision: 1.15 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tk.h>
#include <libhelp/libhelp.h>
#include <liberror/liberror.h>
#include "libuiP.h"

Tcl_Interp* interp = NULL;
static int (*interfaceReadFuncPtr)(int) = NULL;
static int interfaceInputFd;

static void interfaceInputHandler( ClientData data, int mask )
{
   if( interfaceReadFuncPtr != NULL )   
      if( interfaceReadFuncPtr( interfaceInputFd ) <= 0 )
         interfaceRemoveInput( interfaceInputFd );
}

void interfaceRemoveInput( int fd )
{
   if( interfaceInputFd != fd )
      return;

   if( interfaceReadFuncPtr != NULL )
      Tk_DeleteFileHandler( (ClientData)interfaceInputFd );
}

void interfaceSetInput( int fd, int (*readCallback)(int) )
{
   Tk_CreateFileHandler( (ClientData)fd, TK_READABLE, 
                         interfaceInputHandler, NULL );
   interfaceInputFd = fd;
   interfaceReadFuncPtr = readCallback;   
}
         
int displayHelpCallback( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   char* help_tag = NULL;
   
   if( argc != 2 )
   {
      error( "invalid number of argument" );
      exit( 1 );
   }
   
   /* 
    * we check the hard coded help string and
    * use the macro's defined in ../libui.h
    * to use assure we use the same help tags is
    * the other interfaces do.
    */
   if( strcmp( argv[1], "login" ) == 0 )
      help_tag = LoginHelpString;   
   else
   if( strcmp( argv[1], "dialing" ) == 0 )
      help_tag = DialingHelpString;
   else
   if( strcmp( argv[1], "error" ) == 0 )
      help_tag = ErrorHelpString;
   else
   if( strcmp( argv[1], "dial" ) == 0 )
      help_tag = DialHelpString;
   else
   if( strcmp( argv[1], "status" ) == 0 )
      help_tag = StatusHelpString;
   else
   if( strcmp( argv[1], "loginmsg" ) == 0 )
      help_tag = LoginMsgHelpString;
   else
   {
      error( "Invalid help string" );
      exit( 1 );
   }
   
   displayHelp( help_tag );
   return TCL_OK;
}

int Tcl_AppInit( Tcl_Interp* interp )
{
   if (Tcl_Init(interp) == TCL_ERROR)
      return TCL_ERROR;
   if( Tk_Init(interp) == TCL_ERROR )
      return TCL_ERROR;

   return TCL_OK;
}
   
void interfaceCreate( int* argc, char** argv, const char* progName )
{
   /* create interpreter */
   interp = Tcl_CreateInterp();
   
   if( Tcl_AppInit( interp ) != TCL_OK ) {
      error( "tcl_init" );
      exit( 1 );
   }
   /*
    * create help command
    * usage: help <help_tag>
    */
   Tcl_CreateCommand( interp, "help", displayHelpCallback, NULL, NULL );
   
}

void interfaceRun()
{
   Tk_MainLoop();
}


/*
 * EOF libui/tk/interface.c
 */
