#
# $Id: login.tcl,v 1.10 1998/02/17 09:52:53 mdejonge Exp $
#
#   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/login.tcl,v $
# $Revision: 1.10 $
#    Author: Merijn de Jonge
#     Email: mdejonge@wins.uva.nl
# 
#  
# 
# This file is part of the modem communication package.
# Copyright (C) 1996-1998  Merijn de Jonge
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
# 
#
set name     ""
set password ""

wm withdraw .

proc login-dialog-create {} {
   set w .login-dialog

   toplevel    $w -class Dialog
   wm title    $w "Login"
   wm iconname $w "Login"
   
   frame $w.top -relief raised -bd 1
   frame $w.bot -relief raised -bd 1
   
   frame $w.top.msg
   label $w.top.msg.bitmap -bitmap question
   message $w.top.msg.msg \
              -text "Please enter user name and password:" \
              -justify left \
              -width 10i
   pack $w.top.msg.bitmap $w.top.msg.msg \
      -side left
   
   frame $w.top.input
   frame $w.top.input.labels
   frame $w.top.input.entries
   
   label $w.top.input.labels.name \
      -text "User:" \
      -justify left
   label $w.top.input.labels.password \
      -text "Password:" \
      -justify left
   pack $w.top.input.labels.name \
        $w.top.input.labels.password \
           -side top \
           -anchor w \
           -pady 2m
   entry $w.top.input.entries.name \
      -textvariable name
   entry $w.top.input.entries.password \
      -textvariable password -show *

   pack $w.top.input.entries.name \
        $w.top.input.entries.password \
        -side top \
        -expand 1 \
        -fill x \
        -pady 2m
   pack $w.top.input.labels \
        $w.top.input.entries \
           -side left \
           -padx 2m
   
   pack $w.top.msg \
        $w.top.input \
           -side top \
           -padx 5m \
           -pady 5m
   
   button $w.bot.ok \
      -text " OK " \
      -command login-dialog-ok-callback
   button $w.bot.cancel \
      -text " Cancel " \
      -command login-dialog-cancel-callback
   button $w.bot.help \
      -text " Help " \
      -command "help login"

   pack $w.bot.ok \
        $w.bot.cancel \
        $w.bot.help \
           -side left \
           -expand 1 \
           -padx 2m \
           -pady 2m

   pack $w.top \
        $w.bot \
           -side top \
           -expand 1 \
           -fill both
   wm withdraw $w
}

proc login-dialog-ok-callback {} {
   global name password
   login-ok $name $password
}

proc login-dialog-cancel-callback {} {
   login-cancel
}

proc login-dialog-init {{user ""}  {pw ""}} {
   global name password
   set name $user
   set password $pw
}

proc login-dialog-popup {} {
   wm deiconify .login-dialog
}

proc login-dialog-popdown {} {
   wm withdraw .login-dialog
}

#
# EOF libui/tk/login.tcl
#
