/*
 * $Id: loginI.c,v 1.10 1998/02/17 09:52:54 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/loginI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libuiP.h"
#include "login.h"

static loginDialogInfoRec dialogInfo;


void loginDialogCreate()
{
   Tcl_Eval( interp, window );
   Tcl_VarEval( interp, "login-dialog-create", NULL );
}

int LoginCancelCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.cancelCallback();
   interp->result = "0";
   return TCL_OK;
}

int LoginOkCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   loginDialogPopdown();
   dialogInfo.okCallback( argv[1], argv[2] );
   interp->result = "0";
   return TCL_OK;
}
   
void loginDialogInit( loginDialogInfoRec* info )
{
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.okCallback     = info->okCallback;
   Tcl_VarEval( interp, "login-dialog-init ", info->user, " ", info->pw, NULL );

   Tcl_CreateCommand( interp, "login-cancel", LoginCancelCmd, NULL, NULL );
   Tcl_CreateCommand( interp, "login-ok",     LoginOkCmd,     NULL, NULL );
}

void loginDialogPopup()
{
   Tcl_VarEval( interp, "login-dialog-popup", NULL );
}

void loginDialogPopdown()
{
   Tcl_VarEval( interp, "login-dialog-popdown", NULL );
}
/*
 * EOF libui/tk/loginI.c
 */
