#
# $Id: loginMsg.tcl,v 1.9 1998/02/17 09:52:55 mdejonge Exp $
#
#   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/loginMsg.tcl,v $
# $Revision: 1.9 $
#    Author: Merijn de Jonge
#     Email: mdejonge@wins.uva.nl
# 
#  
# 
# This file is part of the modem communication package.
# Copyright (C) 1996-1998  Merijn de Jonge
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
# 
#
wm withdraw .

set name     ""
set time_str "00:00"
set time     0

proc loginMsg-dialog-create {} {
   set w .loginMsg-dialog
   
   toplevel    $w -class Dialog
   wm title    $w "Login..."
   wm iconname $w "Login..."

   frame $w.top -relief raised -bd 1
   frame $w.bot -relief raised -bd 1
   
   frame $w.top.msg
   label $w.top.msg.bitmap -bitmap info
   message $w.top.msg.msg \
              -text "Loging into the network:" \
              -justify left \
              -width 10i
   pack $w.top.msg.bitmap $w.top.msg.msg \
      -side left \
      -padx 4m
   
   frame $w.top.data \
      -relief groove \
      -bd 2
    
   frame $w.top.data.labels
   frame $w.top.data.values
   
   label $w.top.data.labels.name  -text "User:"  -justify left
   label $w.top.data.labels.time    -text "Time:"    -justify left
   pack $w.top.data.labels.name \
        $w.top.data.labels.time \
           -side top \
           -expand 1 \
           -anchor w

  label $w.top.data.values.name  -textvariable name   -justify left
  label $w.top.data.values.time    -textvariable time_str -justify left
  pack $w.top.data.values.name \
       $w.top.data.values.time \
          -side top \
          -expand 1 \
          -anchor w
   pack $w.top.data.labels \
        $w.top.data.values \
           -side left \
           -expand 1

   pack $w.top.msg \
        $w.top.data \
           -side top \
           -expand 1 \
           -fill both \
           -pady 5m \
           -padx 5m

   button $w.bot.cancel \
      -text " Cancel " \
      -command loginMsg-dialog-cancel-callback
   button $w.bot.help \
      -text " Help " \
      -command "help loginmsg"

   pack $w.bot.cancel \
        $w.bot.help \
           -side left \
           -expand 1 \
           -padx 2m \
           -pady 2m
 
   pack $w.top \
        $w.bot \
           -side top \
           -expand 1 \
           -fill both
   wm withdraw $w
}

proc loginMsg-dialog-cancel-callback {} {
   loginMsg-cancel
}

proc loginMsg-dialog-timeout-callback {} {
   loginMsg-timeout
}

proc loginMsg-dialog-init {_name _time} {
   global name time time_str
   set name  $_name
   set time  $_time
   set time_str [clock format $time  -format "%M:%S" -gmt 1]
}

proc loginMsg-dialog-update_time {} {
   global time time_str
   incr time -1
      
   set time_str [clock format $time  -format "%M:%S" -gmt 1]
   if {$time == 0} {
      loginMsg-dialog-timeout-callback
      return
   }
   after 1000 {loginMsg-dialog-update_time}
}

proc loginMsg-dialog-popup {} {
   wm deiconify .loginMsg-dialog
   after 1000 {loginMsg-dialog-update_time}
}

proc loginMsg-dialog-popdown {} {
   wm withdraw .loginMsg-dialog
   after cancel {loginMsg-dialog-update_time}
}

#
# EOF libui/tk/loginMsg.tcl
#
