/*
 * $Id: loginMsgI.c,v 1.10 1998/02/17 09:52:55 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/loginMsgI.c,v $
 * $Revision: 1.10 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libuiP.h"
#include "loginMsg.h"

static loginMsgDialogInfoRec dialogInfo;

void loginMsgDialogCreate()
{
   Tcl_Eval( interp, window );
   Tcl_VarEval( interp, "loginMsg-dialog-create", NULL );
}

int LoginMsgCancelCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.cancelCallback();
   interp->result = "0";
   return TCL_OK;
}

int LoginMsgTimeoutCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.timeoutCallback();
   interp->result = "0";
   return TCL_OK;
}
   

void loginMsgDialogInit( loginMsgDialogInfoRec* info )
{
   char buf[20];
   sprintf( buf, "%ld", info->timeout );
   
   dialogInfo.cancelCallback = info->cancelCallback;
   dialogInfo.timeoutCallback = info->timeoutCallback;
   
   Tcl_VarEval( interp, "loginMsg-dialog-init ", info->user, " ", buf, NULL );

   Tcl_CreateCommand( interp, "loginMsg-cancel", 
                      LoginMsgCancelCmd, NULL, NULL );
   Tcl_CreateCommand( interp, "loginMsg-timeout", 
                      LoginMsgTimeoutCmd, NULL, NULL );
}

void loginMsgDialogPopup()
{
   Tcl_VarEval( interp, "loginMsg-dialog-popup", NULL );
}

void loginMsgDialogPopdown()
{
   Tcl_VarEval( interp, "loginMsg-dialog-popdown", NULL );
}

/*
 * EOF libui/tk/loginMsgI.c
 */
