#
# $Id: status.tcl,v 1.10 1998/02/17 09:52:56 mdejonge Exp $
#
#   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/status.tcl,v $
# $Revision: 1.10 $
#    Author: Merijn de Jonge
#     Email: mdejonge@wins.uva.nl
# 
#  
# 
# This file is part of the modem communication package.
# Copyright (C) 1996-1998  Merijn de Jonge
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 
# 
#
wm withdraw .

set bytes_read    "0      "
set bytes_written "0      "
set speed         "29800 bps"
set time_str      "00:00:00"
set reading       0
set writing       0

proc status-dialog-create {} {
   set w .status-dialog
   
   toplevel $w    -class Dialog
   wm title $w    "Connected:"
   wm iconname $w "Status"

   frame $w.top -relief raised -bd 1
   frame $w.bot -relief raised -bd 1
   frame $w.top.leds -relief groove -bd 2
   frame $w.top.inf1 -relief groove -bd 2
   frame $w.top.inf2 -relief groove -bd 2
   frame $w.top.inf1.labels
   frame $w.top.inf1.values
   frame $w.top.inf2.labels
   frame $w.top.inf2.values
   
   frame $w.top.leds.read  -relief groove -bd 2
   frame $w.top.leds.write -relief groove -bd 2
   
   pack $w.top.leds.read $w.top.leds.write -side top -fill both -expand 1 \
   -ipadx 3m -ipady 3m

   label $w.top.inf1.labels.read -text "Received:"   -justify left
   label $w.top.inf1.labels.write -text "Sent:" -justify left   
   pack  $w.top.inf1.labels.read $w.top.inf1.labels.write \
      -side top -expand 1 -anchor w
   
   label $w.top.inf1.values.read  -text "0" -justify left
   label $w.top.inf1.values.write -text "0"  -justify left
   pack $w.top.inf1.values.read $w.top.inf1.values.write \
      -expand 1 -expand 1 -anchor w -side top
  
   pack $w.top.inf1.labels $w.top.inf1.values \
      -side left -fill both -expand 1 -padx 2m -pady 2m


   label $w.top.inf2.labels.connect -text "Connect:"   -justify left
   label $w.top.inf2.labels.time -text "Time:" -justify left
   pack  $w.top.inf2.labels.connect $w.top.inf2.labels.time \
      -side top -anchor w -expand 1
   label $w.top.inf2.values.connect -textvariable speed -justify left
   label $w.top.inf2.values.time -textvariable time_str -justify left
   pack $w.top.inf2.values.connect $w.top.inf2.values.time \
      -side top -anchor w -expand 1
  
   pack $w.top.inf2.labels $w.top.inf2.values \
      -side left -expand 1 -fill both -padx 2m -pady 2m


   pack $w.top.leds  $w.top.inf1 $w.top.inf2 -side left \
      -pady 2m -padx 2m -fill both -expand 1

   button $w.bot.disconnect \
      -text " Disconnect " \
      -command status-dialog-disconnect-callback
   button $w.bot.help \
      -text " Help " \
      -command "help status"

   pack $w.bot.disconnect \
        $w.bot.help \
           -side left \
           -expand 1\
           -padx 2m \
           -pady 2m
   pack $w.top $w.bot -side top -fill both -expand 1

   wm withdraw $w
}

proc status-dialog-update-time {} {
   global time_str
   set time [status-dialog-time]
   set time_str [clock format $time  -format "%H:%M:%S" -gmt 1]
   after 1000 {status-dialog-update-time}
}

proc status-dialog-reset-read {} {
   global reading bytes_read
   if {"$reading" == "0"} {
      set bg [.status-dialog.top.leds cget -bg]
      .status-dialog.top.leds.read configure -bg $bg
   } else {
      set reading "0"
      after 500 status-dialog-reset-read
   }
   .status-dialog.top.inf1.values.read configure -text "$bytes_read"
}

proc status-dialog-reset-write {} {
   global writing bytes_written
   if {"$writing" == "0"} {
      set bg [.status-dialog.top.leds cget -bg]
      .status-dialog.top.leds.write configure -bg $bg
   } else {
      set writing "0"
      after 500 status-dialog-reset-write
   }
   
   .status-dialog.top.inf1.values.write configure -text "$bytes_written"
}

proc status-dialog-init {bps connectedTo} {
   global speed
   set speed "$bps bps"
   wm title .status-dialog "Connected to $connectedTo"
}

proc status-dialog-receive {bytes} {
   global bytes_read reading

   set bytes_read [expr $bytes_read + $bytes]

   if {"$reading" == "0"} {
      .status-dialog.top.leds.read configure -bg yellow 
      .status-dialog.top.inf1.values.read configure -text "$bytes_read"
      set reading "1"
      after 500 status-dialog-reset-read
   }
}

proc status-dialog-send {bytes} {
   global bytes_written writing
   
   set bytes_written [expr $bytes_written + $bytes]

   if {"$writing" == "0"} {
      .status-dialog.top.leds.write configure -bg yellow 
      .status-dialog.top.inf1.values.write configure -text "$bytes_written"
      set writing "1"
      after 500 status-dialog-reset-write
   }
}

proc status-dialog-disconnect-callback {} {
   status-dialog-disconnect
}

proc status-dialog-popup {} {
   wm deiconify .status-dialog
   after 1000 status-dialog-update-time
}

proc status-dialog-popdown {} {
   wm withdraw .status-dialog
   after cancel status-dialog-update-time
   after cancel status-dialog-reset-write
   after cancel status-dialog-reset-read
}

#
# EOF libui/tk/status.tcl
#
