/*
 * $Id: statusI.c,v 1.11 1998/02/17 09:52:56 mdejonge Exp $
 *
 *   $Source: /home/mdejonge/CVS/projects/modem/libui/tk/statusI.c,v $
 * $Revision: 1.11 $
 *    Author: Merijn de Jonge
 *     Email: mdejonge@wins.uva.nl
 * 
 *  
 * 
 * This file is part of the modem communication package.
 * Copyright (C) 1996-1998  Merijn de Jonge
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "libuiP.h"
#include "status.h"

static statusDialogInfoRec dialogInfo;

void statusDialogCreate()
{
   Tcl_Eval( interp, window );
   Tcl_VarEval( interp, "status-dialog-create", NULL );
}

int StatusTimeCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   time_t t;
   static char buf[20];
   
   t = dialogInfo.timeCallback();
   sprintf( buf, "%ld", t );
   interp->result = buf;
   return TCL_OK;
}

int StatusDisconnectCmd( ClientData clientData, Tcl_Interp* interp,
   int argc, char* argv[] )
{
   dialogInfo.disconnectCallback();
   interp->result = "0";
   return TCL_OK;
}

void statusDialogInit( statusDialogInfoRec* info )
{
   dialogInfo.readCallback = info->readCallback;
   dialogInfo.timeCallback = info->timeCallback;
   dialogInfo.disconnectCallback = info->disconnectCallback;
   dialogInfo.fd1 = info->fd1;   
   dialogInfo.fd2 = info->fd2;
   
   Tcl_VarEval( interp, "status-dialog-init ", 
      info->connectSpeed, " ",
      info->connectedTo,
      NULL );

   Tcl_CreateCommand( interp, "status-dialog-time", StatusTimeCmd, NULL, NULL );
   Tcl_CreateCommand( interp, "status-dialog-disconnect",
      StatusDisconnectCmd, NULL, NULL );
   
}

void infoInputHandler( ClientData data, int mask )
{
   int  fd;
   int  result;
   char buf[20];

   fd = (int)data;
   
   result = dialogInfo.readCallback( fd );
   sprintf( buf, "%d", result );
   if( fd == dialogInfo.fd1 )
      Tcl_VarEval( interp, "status-dialog-receive ",  buf, NULL );
   else
      Tcl_VarEval( interp, "status-dialog-send ",  buf, NULL );
}

void statusDialogPopup()
{
   Tk_CreateFileHandler( (ClientData)dialogInfo.fd1, TK_READABLE, 
                         infoInputHandler, (ClientData)dialogInfo.fd1 );
   Tk_CreateFileHandler( (ClientData)dialogInfo.fd2, TK_READABLE, 
                         infoInputHandler, (ClientData)dialogInfo.fd2);
   Tcl_VarEval( interp, "status-dialog-popup", NULL );
}

void statusDialogPopdown()
{
   Tk_DeleteFileHandler( (ClientData)dialogInfo.fd1 );
   Tk_DeleteFileHandler( (ClientData)dialogInfo.fd2 );
   Tcl_VarEval( interp, "status-dialog-popdown", NULL );
}



/*
 * EOF libui/tk/statusI.c
 */
